/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsComputer;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import jenkins.plugins.openstack.compute.JCloudsSlaveTemplate;
import jenkins.plugins.openstack.compute.SlaveOptions;
import jenkins.plugins.openstack.compute.auth.AbstractOpenstackCredential;
import jenkins.plugins.openstack.compute.auth.OpenstackCredential;
import jenkins.plugins.openstack.compute.auth.OpenstackCredentials;
import jenkins.plugins.openstack.compute.auth.OpenstackCredentialv2;
import jenkins.plugins.openstack.compute.auth.OpenstackCredentialv3;
import jenkins.plugins.openstack.compute.internal.Openstack;
import jenkins.plugins.openstack.compute.slaveopts.LauncherFactory;
import jenkins.util.Timer;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedPlannedNode;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.openstack4j.api.exceptions.AuthenticationException;
import org.openstack4j.model.compute.Server;
import org.springframework.security.core.Authentication;

public class JCloudsCloud
extends Cloud
implements SlaveOptions.Holder {
    private static final Logger LOGGER = Logger.getLogger(JCloudsCloud.class.getName());
    @Nonnull
    private final String endPointUrl;
    private final boolean ignoreSsl;
    @CheckForNull
    private final String zone;
    @Nonnull
    private long cleanfreq = 10L;
    private long lastCleanTime = System.currentTimeMillis();
    @Nonnull
    private SlaveOptions slaveOptions;
    @Nonnull
    private final List<JCloudsSlaveTemplate> templates;
    @Nonnull
    private String credentialId;
    private static final int MaxProvisioningExcessWorkLoadCap = 10;
    @Deprecated
    private transient Integer instanceCap;
    @Deprecated
    private transient Integer retentionTime;
    @Deprecated
    private transient Integer startTimeout;
    @Deprecated
    private transient Boolean floatingIps;
    @Deprecated
    private transient String identity;
    @Deprecated
    private transient Secret credential;

    @Nonnull
    public static List<JCloudsCloud> getClouds() {
        ArrayList<JCloudsCloud> clouds = new ArrayList<JCloudsCloud>();
        for (Cloud c : Jenkins.get().clouds) {
            if (!(c instanceof JCloudsCloud)) continue;
            clouds.add((JCloudsCloud)c);
        }
        return clouds;
    }

    @Nonnull
    public static JCloudsCloud getByName(@Nonnull String name) throws IllegalArgumentException {
        Cloud cloud = Jenkins.get().clouds.getByName(name);
        if (cloud instanceof JCloudsCloud) {
            return (JCloudsCloud)cloud;
        }
        throw new IllegalArgumentException("'" + name + "' is not an OpenStack cloud but " + String.valueOf(cloud));
    }

    @DataBoundConstructor
    @Restricted(value={DoNotUse.class})
    public JCloudsCloud(@Nonnull String name, @Nonnull String endPointUrl, boolean ignoreSsl, @CheckForNull String zone, long cleanfreq, @CheckForNull SlaveOptions slaveOptions, @CheckForNull List<JCloudsSlaveTemplate> templates, @Nonnull String credentialsId) {
        super(Util.fixNull((String)name).trim());
        this.endPointUrl = Util.fixNull((String)endPointUrl).trim();
        this.ignoreSsl = Boolean.TRUE.equals(ignoreSsl);
        this.zone = Util.fixEmptyAndTrim((String)zone);
        this.credentialId = credentialsId;
        this.cleanfreq = cleanfreq == 0L ? 10L : cleanfreq;
        this.slaveOptions = slaveOptions == null ? SlaveOptions.empty() : slaveOptions.eraseDefaults(DescriptorImpl.DEFAULTS);
        this.templates = templates == null ? Collections.emptyList() : Collections.unmodifiableList(templates);
        this.injectReferenceIntoTemplates();
    }

    private Object readResolve() {
        if (this.retentionTime != null || this.startTimeout != null || this.floatingIps != null || this.instanceCap != null) {
            SlaveOptions carry = SlaveOptions.builder().instanceCap(this.instanceCap).retentionTime(this.retentionTime).startTimeout(this.startTimeout).floatingIpPool(this.floatingIps != false ? "public" : null).build();
            this.slaveOptions = DescriptorImpl.DEFAULTS.override(carry);
            this.retentionTime = null;
            this.startTimeout = null;
            this.floatingIps = null;
            this.instanceCap = null;
        }
        LauncherFactory lf = null;
        if ("JNLP".equals(this.slaveOptions.slaveType)) {
            lf = LauncherFactory.JNLP.JNLP;
        } else if (!"JNLP".equals(this.slaveOptions.slaveType) && this.slaveOptions.credentialsId != null) {
            lf = new LauncherFactory.SSH(this.slaveOptions.credentialsId);
        }
        if (lf != null) {
            this.slaveOptions = this.slaveOptions.getBuilder().launcherFactory(lf).build();
        }
        this.injectReferenceIntoTemplates();
        if (this.identity != null) {
            String[] id = this.identity.split(":");
            AbstractOpenstackCredential migratedOpenstackCredential = null;
            if (id.length == 2) {
                String tenant = id[0];
                String username = id[1];
                migratedOpenstackCredential = new OpenstackCredentialv2(CredentialsScope.SYSTEM, null, null, tenant, username, this.credential);
            } else if (id.length == 3) {
                String project = id[0];
                String username = id[1];
                String domain = id[2];
                migratedOpenstackCredential = new OpenstackCredentialv3(CredentialsScope.SYSTEM, null, null, username, domain, project, domain, this.credential);
            }
            if (migratedOpenstackCredential != null) {
                this.credentialId = migratedOpenstackCredential.getId();
                try {
                    OpenstackCredentials.add(migratedOpenstackCredential);
                    OpenstackCredentials.save();
                    this.identity = null;
                    this.credential = null;
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Unable to migrate " + this.name + " cloud credential to the new version", e);
                }
            } else {
                LOGGER.log(Level.SEVERE, "Unable to migrate " + this.name + " cloud credential to the new version");
            }
        }
        return this;
    }

    private void injectReferenceIntoTemplates() {
        for (JCloudsSlaveTemplate t : this.templates) {
            t.setOwner(this);
        }
    }

    @Override
    @Nonnull
    public SlaveOptions getEffectiveSlaveOptions() {
        return DescriptorImpl.DEFAULTS.override(this.slaveOptions);
    }

    @Override
    @Nonnull
    public SlaveOptions getRawSlaveOptions() {
        return this.slaveOptions;
    }

    @Nonnull
    public List<JCloudsSlaveTemplate> getTemplates() {
        return this.templates;
    }

    @Nonnull
    public String getEndPointUrl() {
        return this.endPointUrl;
    }

    @CheckForNull
    public String getZone() {
        return this.zone;
    }

    public void setLastCleanTime(long timeMillis) {
        this.lastCleanTime = timeMillis;
    }

    public long getLastCleanTime() {
        return this.lastCleanTime;
    }

    @CheckForNull
    public long getCleanfreq() {
        return this.cleanfreq;
    }

    @CheckForNull
    public long getCleanfreqToMillis() {
        return this.cleanfreq * 1000L;
    }

    @DataBoundSetter
    public void setCleanfreq(@Nonnull long cleanfreq) {
        this.cleanfreq = cleanfreq;
    }

    @Nonnull
    private Queue<JCloudsSlaveTemplate> getAvailableTemplateProvider(@CheckForNull Label label, int excessWorkload) {
        int globalMax = this.getEffectiveSlaveOptions().getInstanceCap();
        ConcurrentLinkedDeque<JCloudsSlaveTemplate> queue = new ConcurrentLinkedDeque<JCloudsSlaveTemplate>();
        List cloudComputers = JCloudsComputer.getAll().stream().filter(it -> this.name.equals(it.getId().getCloudName())).collect(Collectors.toList());
        int nodeCount = cloudComputers.size();
        if (nodeCount >= globalMax) {
            return queue;
        }
        List<Server> runningNodes = this.getOpenstack().getRunningNodes();
        int serverCount = runningNodes.size();
        if (serverCount >= globalMax) {
            return queue;
        }
        int globalCapacity = globalMax - Math.max(nodeCount, serverCount);
        assert (globalCapacity > 0);
        for (JCloudsSlaveTemplate t : this.templates) {
            if (!t.canProvision(label)) continue;
            SlaveOptions opts = t.getEffectiveSlaveOptions();
            int templateMax = opts.getInstanceCap();
            long templateNodeCount = Math.max(cloudComputers.stream().filter(it -> t.getName().equals(it.getId().getTemplateName())).count(), runningNodes.stream().filter(t::hasProvisioned).count());
            if (templateNodeCount >= (long)templateMax) continue;
            long templateCapacity = (long)templateMax - templateNodeCount;
            assert (templateCapacity > 0L);
            int i = 0;
            while ((long)i < templateCapacity) {
                int size = queue.size();
                if (size >= globalCapacity || size >= excessWorkload) {
                    return queue;
                }
                queue.add(t);
                ++i;
            }
        }
        return queue;
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Cloud.CloudState cs, int excessWorkload) {
        int numExecutors;
        Label label = cs.getLabel();
        Queue<JCloudsSlaveTemplate> templateProvider = this.getAvailableTemplateProvider(label, excessWorkload);
        ArrayList<NodeProvisioner.PlannedNode> plannedNodeList = new ArrayList<NodeProvisioner.PlannedNode>();
        for (excessWorkload = Math.min(excessWorkload, 10); excessWorkload > 0 && !Jenkins.get().isQuietingDown() && !Jenkins.get().isTerminating(); excessWorkload -= numExecutors) {
            JCloudsSlaveTemplate template = templateProvider.poll();
            if (template == null) {
                LOGGER.info("Instance cap exceeded for cloud " + this.name + " while provisioning for label " + String.valueOf(label));
                break;
            }
            LOGGER.fine("Provisioning slave for " + String.valueOf(label) + " from template " + template.getName());
            numExecutors = template.getEffectiveSlaveOptions().getNumExecutors();
            ProvisioningActivity.Id id = new ProvisioningActivity.Id(this.name, template.getName());
            Future<Node> task = Computer.threadPoolForRemoting.submit(new NodeCallable(this, template, id));
            plannedNodeList.add((NodeProvisioner.PlannedNode)new TrackedPlannedNode(id, numExecutors, task));
        }
        return plannedNodeList;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public String slaveIsWaitingFor(@Nonnull JCloudsSlave slave) throws ProvisioningFailedException {
        return slave.getSlaveOptions().getLauncherFactory().isWaitingFor(slave);
    }

    public boolean canProvision(Cloud.CloudState cs) {
        for (JCloudsSlaveTemplate t : this.templates) {
            if (!t.canProvision(cs.getLabel())) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public JCloudsSlaveTemplate getTemplate(String name) {
        for (JCloudsSlaveTemplate t : this.templates) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    @RequirePOST
    public void doProvision(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name) throws IOException {
        int globalCap;
        if (!this.hasPermission(Item.CONFIGURE) && !this.hasPermission(Cloud.PROVISION)) {
            this.checkPermission(Cloud.PROVISION);
        }
        if (rsp.getContentType() == null) {
            rsp.setContentType("text/xml");
        }
        if (name == null) {
            JCloudsCloud.sendPlaintextError("The slave template name query parameter is missing", rsp);
            return;
        }
        JCloudsSlaveTemplate t = this.getTemplate(name);
        if (t == null) {
            JCloudsCloud.sendPlaintextError("No such slave template with name : " + name, rsp);
            return;
        }
        List<Server> nodes = this.getOpenstack().getRunningNodes();
        int global = nodes.size();
        if (global >= (globalCap = this.getEffectiveSlaveOptions().getInstanceCap().intValue())) {
            String msg = String.format("Instance cap of %s is now reached: %d", this.name, globalCap);
            JCloudsCloud.sendPlaintextError(msg, rsp);
            return;
        }
        int template = 0;
        for (Server node : nodes) {
            if (!t.hasProvisioned(node)) continue;
            ++template;
        }
        int templateCap = t.getEffectiveSlaveOptions().getInstanceCap();
        if (template >= templateCap) {
            String msg = String.format("Instance cap for this template (%s/%s) is now reached: %d", this.name, name, templateCap);
            JCloudsCloud.sendPlaintextError(msg, rsp);
            return;
        }
        try {
            this.provisionAsynchronouslyNotToBlockTheRequestThread(t);
            rsp.getWriter().println("<ok>Provisioning started</ok>");
        }
        catch (Throwable ex) {
            JCloudsCloud.sendPlaintextError(ex.getMessage(), rsp);
        }
    }

    private void provisionAsynchronouslyNotToBlockTheRequestThread(JCloudsSlaveTemplate t) throws Throwable {
        Authentication auth = Jenkins.getAuthentication2();
        Callable<Void> performProvisioning = () -> {
            Void void_;
            block7: {
                ACLContext ignored = ACL.as2((Authentication)auth);
                try {
                    this.provisionSlaveExplicitly(t);
                    void_ = null;
                    if (ignored == null) break block7;
                }
                catch (Throwable ex) {
                    try {
                        LOGGER.log(Level.WARNING, "Provisioning failed", ex);
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                ignored.close();
            }
            return void_;
        };
        ScheduledFuture<Void> schedule = Timer.get().schedule(performProvisioning, 0L, TimeUnit.SECONDS);
        try {
            schedule.get(3L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    private static void sendPlaintextError(String message, StaplerResponse rsp) throws IOException {
        rsp.setStatus(400);
        PrintWriter response = rsp.getWriter();
        response.println("<error>" + message + "</error>");
    }

    @Restricted(value={NoExternalUse.class})
    @Nonnull
    JCloudsSlave provisionSlaveExplicitly(@Nonnull JCloudsSlaveTemplate template) throws IOException, Openstack.ActionFailed {
        JCloudsSlave node;
        CloudStatistics.ProvisioningListener provisioningListener = CloudStatistics.ProvisioningListener.get();
        ProvisioningActivity.Id id = new ProvisioningActivity.Id(this.name, template.getName());
        try {
            provisioningListener.onStarted(id);
            node = template.provisionSlave(this, id);
            provisioningListener.onComplete(id, (Node)node);
        }
        catch (Throwable ex) {
            provisioningListener.onFailure(id, ex);
            throw ex;
        }
        Jenkins.get().addNode((Node)node);
        return node;
    }

    @Restricted(value={NoExternalUse.class})
    @Nonnull
    public Openstack getOpenstack() throws LoginFailure {
        try {
            OpenstackCredential credential = OpenstackCredentials.getCredential(this.getCredentialsId());
            if (credential == null) {
                throw new LoginFailure("No credentials found for cloud " + this.name + " (id=" + this.getCredentialsId() + ")");
            }
            return Openstack.Factory.get(this.endPointUrl, this.ignoreSsl, credential, this.zone, this.cleanfreq);
        }
        catch (AuthenticationException ex) {
            throw new LoginFailure(this.name, ex);
        }
        catch (FormValidation ex) {
            throw new LoginFailure(this.name, ex);
        }
    }

    public String getCredentialsId() {
        return this.credentialId;
    }

    @Restricted(value={DoNotUse.class})
    public boolean getIgnoreSsl() {
        return this.ignoreSsl;
    }

    public String toString() {
        return String.format("OpenStack cloud %s for %s", this.name, this.endPointUrl);
    }

    @Extension
    @Symbol(value={"openstack"})
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        private static final SlaveOptions DEFAULTS = SlaveOptions.builder().instanceCap(10).instancesMin(0).retentionTime(30).startTimeout(600000).numExecutors(1).fsRoot("/jenkins").securityGroups("default").configDrive(false).build();

        @Nonnull
        public String getDisplayName() {
            return "Cloud (OpenStack)";
        }

        public static SlaveOptions getDefaultOptions() {
            return DEFAULTS;
        }

        @Restricted(value={DoNotUse.class})
        @RequirePOST
        public FormValidation doCheckName(@QueryParameter String value) {
            try {
                Jenkins.checkGoodName((String)value);
                return FormValidation.ok();
            }
            catch (Failure ex) {
                return FormValidation.error((String)ex.getMessage());
            }
        }

        @Restricted(value={DoNotUse.class})
        @RequirePOST
        public FormValidation doTestConnection(@QueryParameter boolean ignoreSsl, @QueryParameter String credentialsId, @QueryParameter String endPointUrl, @QueryParameter String zone, @QueryParameter long cleanfreq) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                OpenstackCredential openstackCredential = OpenstackCredentials.getCredential(credentialsId);
                if (openstackCredential == null) {
                    throw FormValidation.error((String)("No credential found for " + credentialsId));
                }
                Openstack openstack = Openstack.Factory.get(endPointUrl, ignoreSsl, openstackCredential, zone, cleanfreq);
                Throwable ex = openstack.sanityCheck();
                if (ex != null) {
                    return FormValidation.warning((Throwable)ex, (String)("Connection not validated, plugin might not operate correctly: " + ex.getMessage()));
                }
                return FormValidation.okWithMarkup((String)("Connection succeeded!<br/><small>" + Util.escape((String)openstack.getInfo()) + "</small>"));
            }
            catch (FormValidation ex) {
                return ex;
            }
            catch (Exception ex) {
                return FormValidation.error((Throwable)ex, (String)("Cannot connect to specified cloud, please check the identity and credentials: " + ex.getMessage()));
            }
        }

        @Restricted(value={DoNotUse.class})
        @RequirePOST
        public FormValidation doCheckEndPointUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.validateRequired((String)value);
            }
            try {
                new URL(value);
            }
            catch (MalformedURLException ex) {
                return FormValidation.error((Throwable)ex, (String)"The endpoint must be URL");
            }
            return FormValidation.ok();
        }

        @Restricted(value={DoNotUse.class})
        @RequirePOST
        public FormValidation doCheckCleanfreq(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                long parsedCleanFreq = Long.parseLong(value);
                if (parsedCleanFreq == 0L) {
                    NumberFormatException nfe = new NumberFormatException("cleanfreq should be strictly greater than 0");
                    throw nfe;
                }
            }
            catch (NumberFormatException ex) {
                return FormValidation.error((Throwable)ex, (String)"Clean frequency must be an integer strictly greater than 0 (>=1)");
            }
            return FormValidation.ok();
        }

        @Restricted(value={DoNotUse.class})
        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems() {
            Jenkins jenkins = Jenkins.get();
            jenkins.checkPermission(Jenkins.ADMINISTER);
            return new StandardListBoxModel().includeMatchingAs(ACL.SYSTEM2, (ItemGroup)jenkins, StandardCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(OpenstackCredential.class)).includeEmptyValue();
        }
    }

    private static final class NodeCallable
    implements Callable<Node> {
        private final JCloudsCloud cloud;
        private final JCloudsSlaveTemplate template;
        private final ProvisioningActivity.Id id;

        NodeCallable(JCloudsCloud cloud, JCloudsSlaveTemplate template, ProvisioningActivity.Id id) {
            this.cloud = cloud;
            this.template = template;
            this.id = id;
        }

        @Override
        public Node call() {
            JCloudsSlave jcloudsSlave = this.template.provisionSlave(this.cloud, this.id);
            LOGGER.fine(String.format("Slave %s launched successfully", jcloudsSlave.getDisplayName()));
            return jcloudsSlave;
        }
    }

    public static final class LoginFailure
    extends RuntimeException {
        private static final long serialVersionUID = 4085466675398031930L;

        private LoginFailure(String name, FormValidation ex) {
            super("Openstack authentication invalid fro cloud " + name + ": " + ex.getMessage(), ex);
        }

        private LoginFailure(String name, AuthenticationException ex) {
            super("Failure to authenticate for cloud " + name + ": " + ex.toString());
        }

        private LoginFailure(String msg) {
            super(msg);
        }
    }

    public static final class ProvisioningFailedException
    extends RuntimeException {
        private static final long serialVersionUID = -8524954909721965323L;

        public ProvisioningFailedException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public ProvisioningFailedException(String msg) {
            super(msg);
        }
    }
}

