/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Executor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.slaves.OfflineCause;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.CauseOfInterruption;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsComputer;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import jenkins.plugins.openstack.compute.ServerScope;
import jenkins.plugins.openstack.compute.internal.DestroyMachine;
import jenkins.plugins.openstack.compute.internal.Openstack;
import org.jenkinsci.plugins.resourcedisposer.AsyncResourceDisposer;
import org.jenkinsci.plugins.resourcedisposer.Disposable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.openstack4j.model.compute.Server;

@Extension
@Restricted(value={NoExternalUse.class})
public final class JCloudsCleanupThread
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(JCloudsCleanupThread.class.getName());

    public JCloudsCleanupThread() {
        super("OpenStack slave cleanup");
    }

    public long getRecurrencePeriod() {
        long cleanFreq = 1000L;
        return cleanFreq;
    }

    public void execute(TaskListener listener) {
        try {
            this.terminateNodesPendingDeletion();
            HashMap<JCloudsCloud, List<Server>> runningServers = this.destroyServersOutOfScope();
            this.terminatesNodesWithoutServers(runningServers);
            this.cleanOrphanedFips();
            this.setCloudLastCleanTime();
        }
        catch (JCloudsCloud.LoginFailure ex) {
            LOGGER.log(Level.WARNING, "Unable to authenticate: " + ex.getMessage());
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, "Unable to perform the cleanup", ex);
        }
    }

    private void cleanOrphanedFips() {
        for (JCloudsCloud cloud : JCloudsCloud.getClouds()) {
            if (System.currentTimeMillis() - cloud.getLastCleanTime() < cloud.getCleanfreqToMillis()) continue;
            Openstack openstack = cloud.getOpenstack();
            List<String> leaked = openstack.getFreeFipIds();
            if (leaked.isEmpty()) {
                return;
            }
            LOGGER.info("Cleaning up floating IPs leaked from cloud " + cloud.name + ": " + String.valueOf(leaked));
            for (String fip : leaked) {
                try {
                    openstack.destroyFip(fip);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Unable to release floating IP " + fip + " leaked from cloud " + cloud.name, ex);
                }
            }
        }
    }

    private void setCloudLastCleanTime() {
        for (JCloudsCloud cloud : JCloudsCloud.getClouds()) {
            if (System.currentTimeMillis() - cloud.getLastCleanTime() < cloud.getCleanfreqToMillis()) continue;
            cloud.setLastCleanTime(System.currentTimeMillis());
        }
    }

    private void terminateNodesPendingDeletion() {
        for (JCloudsComputer comp : JCloudsComputer.getAll()) {
            JCloudsCloud cloud = JCloudsCloud.getByName(comp.getId().getCloudName());
            if (System.currentTimeMillis() - cloud.getLastCleanTime() < cloud.getCleanfreqToMillis() || !comp.isIdle()) continue;
            OfflineCause offlineCause = comp.getNode().getFatalOfflineCause();
            if (comp.isPendingDelete()) {
                LOGGER.log(Level.INFO, "Deleting pending node " + comp.getName() + ". Reason: " + String.valueOf(comp.getOfflineCause()));
                this.deleteComputer(comp);
                continue;
            }
            if (offlineCause == null) continue;
            LOGGER.log(Level.WARNING, "Deleting broken node " + comp.getName() + " (" + this.getTerminalDiagnosis(comp) + "). Reason: " + String.valueOf(comp.getOfflineCause()));
            this.deleteComputer(comp);
        }
    }

    private String getTerminalDiagnosis(JCloudsComputer comp) {
        try {
            Server server;
            JCloudsCloud cloud;
            JCloudsSlave node = comp.getNode();
            if (node == null) {
                return "Node is gone";
            }
            try {
                cloud = JCloudsCloud.getByName(comp.getId().getCloudName());
            }
            catch (IllegalArgumentException e) {
                return "Cloud no longer configured - cannot get more info";
            }
            try {
                server = cloud.getOpenstack().getServerById(node.getServerId());
            }
            catch (NoSuchElementException e) {
                return "Server does not exist in OpenStack";
            }
            return server.toString();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed diagnosing computer failure", ex);
            return "none";
        }
    }

    private void deleteComputer(JCloudsComputer comp) {
        try {
            comp.deleteSlave();
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to disconnect and delete " + comp.getName(), e);
        }
    }

    private void deleteComputer(JCloudsComputer comp, CauseOfInterruption coi) {
        try {
            for (Executor e : comp.getExecutors()) {
                e.interrupt(Result.ABORTED, new CauseOfInterruption[]{coi});
            }
            for (Executor e : comp.getOneOffExecutors()) {
                e.interrupt(Result.ABORTED, new CauseOfInterruption[]{coi});
            }
            comp.deleteSlave();
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to disconnect and delete " + comp.getName(), e);
        }
    }

    @Nonnull
    private HashMap<JCloudsCloud, List<Server>> destroyServersOutOfScope() {
        HashMap<JCloudsCloud, List<Server>> runningServers = new HashMap<JCloudsCloud, List<Server>>();
        for (JCloudsCloud jc : JCloudsCloud.getClouds()) {
            if (System.currentTimeMillis() - jc.getLastCleanTime() < jc.getCleanfreqToMillis()) continue;
            runningServers.put(jc, new ArrayList());
            List<Server> servers = jc.getOpenstack().getRunningNodes();
            for (Server server : servers) {
                ServerScope scope = ServerScope.extract(server);
                if (scope.isOutOfScope(server)) {
                    LOGGER.info("Server " + server.getName() + " run out of its scope " + String.valueOf(scope) + ". Terminating: " + String.valueOf(server));
                    AsyncResourceDisposer.get().dispose(new Disposable[]{new DestroyMachine(jc.name, server.getId())});
                    continue;
                }
                runningServers.get(jc).add(server);
            }
        }
        return runningServers;
    }

    private void terminatesNodesWithoutServers(@Nonnull HashMap<JCloudsCloud, List<Server>> runningServers) {
        HashMap<String, JCloudsComputer> jenkinsComputers = new HashMap<String, JCloudsComputer>();
        for (JCloudsComputer jCloudsComputer : JCloudsComputer.getAll()) {
            JCloudsSlave node;
            JCloudsCloud cloud = JCloudsCloud.getByName(jCloudsComputer.getId().getCloudName());
            if (System.currentTimeMillis() - cloud.getLastCleanTime() < cloud.getCleanfreqToMillis() || (node = jCloudsComputer.getNode()) == null) continue;
            jenkinsComputers.put(node.getServerId(), jCloudsComputer);
        }
        for (Map.Entry entry : runningServers.entrySet()) {
            for (Server server : (List)entry.getValue()) {
                jenkinsComputers.remove(server.getId());
            }
        }
        for (Map.Entry entry : jenkinsComputers.entrySet()) {
            JCloudsCloud cloud;
            JCloudsComputer computer = (JCloudsComputer)((Object)entry.getValue());
            String id = (String)entry.getKey();
            String cloudName = computer.getId().getCloudName();
            try {
                cloud = JCloudsCloud.getByName(cloudName);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning("The cloud " + cloudName + " does not longer exists for " + computer.getName());
                continue;
            }
            try {
                Server explicitLookup = cloud.getOpenstack().getServerById(id);
                if (Openstack.isOccupied(explicitLookup)) {
                    LOGGER.severe(((Object)((Object)this)).getClass().getSimpleName() + " incorrectly detected orphaned computer for " + String.valueOf(explicitLookup));
                    continue;
                }
            }
            catch (NoSuchElementException explicitLookup) {
                // empty catch block
            }
            String msg = "OpenStack server (" + id + ") is not running for computer " + computer.getName() + ". Terminating!";
            LOGGER.warning(msg);
            this.deleteComputer(computer, new MessageInterruption(msg));
        }
    }

    protected Level getNormalLoggingLevel() {
        return Level.OFF;
    }

    protected Level getSlowLoggingLevel() {
        return Level.INFO;
    }

    private static class MessageInterruption
    extends CauseOfInterruption {
        private static final long serialVersionUID = 7125610351278586647L;
        private final String msg;

        private MessageInterruption(String msg) {
            this.msg = msg;
        }

        public String getShortDescription() {
            return this.msg;
        }
    }
}

