/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.plugins.openstack.compute.InstancesToRun;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsSlaveTemplate;
import jenkins.plugins.openstack.compute.ServerScope;
import jenkins.plugins.openstack.compute.internal.DestroyMachine;
import jenkins.plugins.openstack.compute.internal.Openstack;
import org.jenkinsci.plugins.resourcedisposer.AsyncResourceDisposer;
import org.jenkinsci.plugins.resourcedisposer.Disposable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.openstack4j.model.compute.Server;

public class JCloudsBuildWrapper
extends BuildWrapper {
    private final List<InstancesToRun> instancesToRun;

    @DataBoundConstructor
    public JCloudsBuildWrapper(List<InstancesToRun> instancesToRun) {
        this.instancesToRun = instancesToRun;
    }

    @Restricted(value={NoExternalUse.class})
    public List<InstancesToRun> getInstancesToRun() {
        return this.instancesToRun;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, final BuildListener listener) {
        ServerScope.Build scope = new ServerScope.Build((Run)build);
        Iterable nodePlans = this.instancesToRun.stream().map(instance -> {
            String templateName;
            JCloudsCloud cloud = JCloudsCloud.getByName(Objects.requireNonNull(instance.cloudName));
            JCloudsSlaveTemplate template = cloud.getTemplate(templateName = Util.replaceMacro((String)instance.getActualTemplateName(), (VariableResolver)build.getBuildVariableResolver()));
            if (template == null) {
                throw new IllegalArgumentException("No such template " + templateName);
            }
            return new NodePlan(cloud, template, instance.count, scope);
        }).collect(Collectors.toList());
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Computer.threadPoolForRemoting);
        final ImmutableList.Builder cloudTemplateNodeBuilder = ImmutableList.builder();
        ImmutableList.Builder plannedInstancesBuilder = ImmutableList.builder();
        final AtomicInteger failedLaunches = new AtomicInteger();
        for (final NodePlan nodePlan : nodePlans) {
            int i = 0;
            while (i < nodePlan.getCount()) {
                final int index = i++;
                listener.getLogger().printf("Queuing cloud instance: #%d %s %s%n", index, nodePlan.getCloud(), nodePlan.getTemplate());
                ListenableFuture provisionTemplate = executor.submit(nodePlan.getNodeSupplier());
                FutureCallback<Server> callback = new FutureCallback<Server>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSuccess(Server result) {
                        if (result != null) {
                            ImmutableList.Builder builder = cloudTemplateNodeBuilder;
                            synchronized (builder) {
                                cloudTemplateNodeBuilder.add((Object)new RunningNode(nodePlan.getCloud(), result));
                            }
                        } else {
                            failedLaunches.incrementAndGet();
                        }
                    }

                    public void onFailure(@Nonnull Throwable t) {
                        failedLaunches.incrementAndGet();
                        listener.error("Error while launching instance: #%d, %s %s:%n%s%n", new Object[]{index, nodePlan.getCloud(), nodePlan.getTemplate(), Functions.printThrowable((Throwable)t)});
                    }
                };
                Futures.addCallback((ListenableFuture)provisionTemplate, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
                plannedInstancesBuilder.add((Object)provisionTemplate);
            }
        }
        List nodesActuallyLaunched = (List)Futures.getUnchecked((Future)Futures.successfulAsList((Iterable)plannedInstancesBuilder.build()));
        final ImmutableList runningNode = cloudTemplateNodeBuilder.build();
        if (failedLaunches.get() > 0) {
            JCloudsBuildWrapper.terminateNodes((Iterable<RunningNode>)runningNode);
            throw new IllegalStateException("One or more instances failed to launch.");
        }
        assert (runningNode.size() == nodesActuallyLaunched.size()) : String.format("expected nodes from callbacks to be the same count as those from the list of futures!%nfromCallbacks:%s%nfromFutures%s%n", runningNode, nodesActuallyLaunched);
        final String ipsString = this.getIpsString((Iterable<RunningNode>)runningNode);
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.put("JCLOUDS_IPS", ipsString);
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                JCloudsBuildWrapper.terminateNodes((Iterable<RunningNode>)runningNode);
                return true;
            }
        };
    }

    @Nonnull
    private String getIpsString(Iterable<RunningNode> runningNodes) {
        ArrayList<String> ips = new ArrayList<String>(this.instancesToRun.size());
        for (RunningNode node : runningNodes) {
            String addr = Openstack.getAccessIpAddress(node.getNode());
            if (addr != null) {
                ips.add(addr);
                continue;
            }
            ips.add("");
        }
        return String.join((CharSequence)",", ips);
    }

    private static void terminateNodes(Iterable<RunningNode> runningNodes) {
        AsyncResourceDisposer disposer = AsyncResourceDisposer.get();
        for (RunningNode rn : runningNodes) {
            disposer.dispose(new Disposable[]{new DestroyMachine(rn.getCloudName(), rn.getNode().getId())});
        }
    }

    public static class NodePlan {
        private final JCloudsCloud cloud;
        private final JCloudsSlaveTemplate template;
        private final int count;
        private final ServerScope.Build scope;

        NodePlan(JCloudsCloud cloud, JCloudsSlaveTemplate template, int count, ServerScope.Build scope) {
            this.cloud = cloud;
            this.template = template;
            this.count = count;
            this.scope = scope;
        }

        public String getCloud() {
            return this.cloud.name;
        }

        public String getTemplate() {
            return this.template.getName();
        }

        public int getCount() {
            return this.count;
        }

        Callable<Server> getNodeSupplier() {
            final JCloudsSlaveTemplate template1 = this.template;
            return new Callable<Server>(){
                @Nonnull
                private final JCloudsSlaveTemplate template;
                {
                    this.template = template1;
                }

                @Override
                public Server call() {
                    return this.template.provisionServer(scope, null);
                }
            };
        }
    }

    public static class RunningNode {
        private final String cloud;
        private final Server node;

        RunningNode(String cloud, Server node) {
            this.cloud = cloud;
            this.node = node;
        }

        public String getCloudName() {
            return this.cloud;
        }

        public Server getNode() {
            return this.node;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "OpenStack Instance Creation";
        }

        public boolean isApplicable(AbstractProject item) {
            return true;
        }
    }
}

