/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.workflow.internal;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.openstack4j.api.workflow.WorkbookDefinitionService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.payloads.InputStreamPayload;
import org.openstack4j.model.workflow.Scope;
import org.openstack4j.model.workflow.WorkbookDefinition;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.workflow.domain.MistralWorkbookDefinition;
import org.openstack4j.openstack.workflow.internal.BaseMistralService;

public class WorkbookDefinitionServiceImpl
extends BaseMistralService
implements WorkbookDefinitionService {
    @Override
    public List<? extends WorkbookDefinition> list() {
        return this.get(MistralWorkbookDefinition.MistralWorkbookDefinitions.class, this.uri("/workbooks", new Object[0])).execute().getList();
    }

    @Override
    public WorkbookDefinition create(InputStream wfText, Scope scope) {
        Objects.requireNonNull(wfText);
        Objects.requireNonNull(scope);
        BaseOpenStackService.Invocation<MistralWorkbookDefinition> invocation = this.post(MistralWorkbookDefinition.class, this.uri("/workbooks?scope=%s", scope.toString().toLowerCase()));
        return invocation.entity(new InputStreamPayload(wfText)).execute();
    }

    @Override
    public WorkbookDefinition get(String identifier) {
        return this.get(MistralWorkbookDefinition.class, this.uri("/workbooks/%s", identifier)).execute();
    }

    @Override
    public ActionResponse delete(String identifier) {
        return this.deleteWithResponse(this.uri("/workbooks/%s", identifier)).execute();
    }
}

