/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.telemetry.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.common.builder.BasicResourceBuilder;
import org.openstack4j.model.telemetry.Alarm;
import org.openstack4j.model.telemetry.builder.AlarmBuilder;
import org.openstack4j.util.ToStringHelper;

public class CeilometerAlarm
implements Alarm {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private Alarm.Type type;
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="alarm_actions")
    private List<String> alarmActions;
    @JsonProperty(value="alarm_id")
    private String alarmId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="enabled")
    private boolean isEnabled;
    @JsonProperty(value="insufficient_data_actions")
    private List<String> insufficientDataActions;
    @JsonProperty(value="ok_actions")
    private List<String> okActions;
    @JsonProperty(value="repeat_actions")
    private boolean repeatActions;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="state_timestamp")
    private String stateTimestamp;
    @JsonProperty(value="threshold_rule")
    private CeilometerThresholdRule thresholdRule;
    @JsonProperty(value="combination_rule")
    private CeilometerCombinationRule combinationRule;
    @JsonProperty(value="composite_rule")
    private Map<String, Object> compositeRule;
    @JsonProperty(value="gnocchi_resources_threshold_rule")
    private CeilometerGnocchiResourcesThresholdRule gnocchiResourcesThresholdRule;
    @JsonProperty(value="gnocchi_aggregation_by_metrics_threshold_rule")
    private CeilometerGnocchiAggregationByMetricsThresholdRule gnocchiAggregationByMetricsThresholdRule;
    @JsonProperty(value="gnocchi_aggregation_by_resources_threshold_rule")
    private CeilometerGnocchiAggregationByResourcesThresholdRule gnocchiAggregationByResourcesThresholdRule;
    @JsonProperty(value="timestamp")
    private String timestamp;

    public static AlarmBuilder builder() {
        return new AlarmConcreteBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public Alarm.Type getType() {
        return this.type;
    }

    @Override
    public void setType(Alarm.Type type) {
        this.type = type;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.alarmId).add("name", this.name).add("enabled", this.isEnabled).add("project_id", this.projectId).add("type", (Object)this.type).add("user_id", this.userId).toString();
    }

    @Override
    public List<String> getAlarmActions() {
        return this.alarmActions;
    }

    @Override
    public void setAlarmActions(List<String> alarmActions) {
        this.alarmActions = alarmActions;
    }

    @Override
    public String getAlarmId() {
        return this.alarmId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void isEnabled(boolean newValue) {
        this.isEnabled = newValue;
    }

    @Override
    public List<String> getInsufficientDataActions() {
        return this.insufficientDataActions;
    }

    @Override
    public void setInsufficientDataActions(List<String> insufficientDataActions) {
        this.insufficientDataActions = insufficientDataActions;
    }

    @Override
    public List<String> getOkActions() {
        return this.okActions;
    }

    @Override
    public void setOkActions(List<String> okActions) {
        this.okActions = okActions;
    }

    @Override
    public boolean getRepeatActions() {
        return this.repeatActions;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getStateTimestamp() {
        return this.stateTimestamp;
    }

    @Override
    public Alarm.ThresholdRule getThresholdRule() {
        return this.thresholdRule;
    }

    @Override
    public void setThresholdRule(CeilometerThresholdRule tr) {
        this.thresholdRule = tr;
    }

    @Override
    public Alarm.CombinationRule getCombinationRule() {
        return this.combinationRule;
    }

    @Override
    public Map<String, Object> getCompositeRule() {
        return this.compositeRule;
    }

    @Override
    public Alarm.GnocchiResourcesThresholdRule getGnocchiResourcesThresholdRule() {
        return this.gnocchiResourcesThresholdRule;
    }

    @Override
    public void setGnocchiResourcesThresholdRule(CeilometerGnocchiResourcesThresholdRule ceilometerGnocchiResourcesThresholdRule) {
        this.gnocchiResourcesThresholdRule = ceilometerGnocchiResourcesThresholdRule;
    }

    @Override
    public Alarm.GnocchiAggregationByMetricsThresholdRule getGnocchiAggregationByMetricsThresholdRule() {
        return this.gnocchiAggregationByMetricsThresholdRule;
    }

    @Override
    public void setGnocchiAggregationByMetricsThresholdRule(CeilometerGnocchiAggregationByMetricsThresholdRule ceilometerGnocchiAggregationByMetricsThresholdRule) {
        this.gnocchiAggregationByMetricsThresholdRule = ceilometerGnocchiAggregationByMetricsThresholdRule;
    }

    @Override
    public Alarm.GnocchiAggregationByResourcesThresholdRule getGnocchiAggregationByResourcesThresholdRule() {
        return this.gnocchiAggregationByResourcesThresholdRule;
    }

    @Override
    public void setGnocchiAggregationByResourcesThresholdRule(CeilometerGnocchiAggregationByResourcesThresholdRule ceilometerGnocchiAggregationByResourcesThresholdRule) {
        this.gnocchiAggregationByResourcesThresholdRule = ceilometerGnocchiAggregationByResourcesThresholdRule;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setRepeateActions(Boolean repeatActions) {
        this.repeatActions = repeatActions;
    }

    @Override
    public String getId() {
        return this.alarmId;
    }

    @Override
    public void setId(String id) {
        this.alarmId = id;
    }

    @Override
    public AlarmBuilder toBuilder() {
        return new AlarmConcreteBuilder(this);
    }

    public static class AlarmConcreteBuilder
    extends BasicResourceBuilder<Alarm, AlarmConcreteBuilder>
    implements AlarmBuilder {
        private CeilometerAlarm m;

        AlarmConcreteBuilder() {
            this(new CeilometerAlarm());
        }

        AlarmConcreteBuilder(CeilometerAlarm m) {
            this.m = m;
        }

        @Override
        public Alarm build() {
            return this.m;
        }

        @Override
        public AlarmBuilder from(Alarm in) {
            this.m = (CeilometerAlarm)in;
            return this;
        }

        @Override
        public AlarmBuilder okActions(List<String> okActions) {
            this.m.okActions = okActions;
            return this;
        }

        @Override
        public AlarmBuilder insufficientDataActions(List<String> insufficientDataActions) {
            this.m.insufficientDataActions = insufficientDataActions;
            return this;
        }

        @Override
        protected Alarm reference() {
            return this.m;
        }

        @Override
        public AlarmBuilder type(Alarm.Type type) {
            this.m.type = type;
            return this;
        }

        @Override
        public AlarmBuilder thresholeRule(CeilometerThresholdRule tr) {
            this.m.thresholdRule = tr;
            return this;
        }

        @Override
        public AlarmBuilder repeatActions(boolean repeatActions) {
            this.m.repeatActions = repeatActions;
            return this;
        }

        @Override
        public AlarmBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public AlarmBuilder alarmActions(List<String> alarmActions) {
            this.m.alarmActions = alarmActions;
            return this;
        }

        @Override
        public AlarmBuilder isEnabled(boolean isEnabled) {
            this.m.isEnabled = isEnabled;
            return this;
        }

        @Override
        public AlarmBuilder combinationRule(CeilometerCombinationRule ce) {
            this.m.combinationRule = ce;
            return this;
        }

        @Override
        public AlarmBuilder compositeRule(Map<String, Object> cr) {
            this.m.compositeRule = cr;
            return this;
        }

        @Override
        public AlarmBuilder gnocchiResourcesThresholdRule(CeilometerGnocchiResourcesThresholdRule ceilometerGnocchiResourcesThresholdRule) {
            this.m.gnocchiResourcesThresholdRule = ceilometerGnocchiResourcesThresholdRule;
            return this;
        }

        @Override
        public AlarmBuilder gnocchiAggregationByMetricsThresholdRule(CeilometerGnocchiAggregationByMetricsThresholdRule ceilometerGnocchiAggregationByMetricsThresholdRule) {
            this.m.gnocchiAggregationByMetricsThresholdRule = ceilometerGnocchiAggregationByMetricsThresholdRule;
            return this;
        }

        @Override
        public AlarmBuilder gnocchiAggregationByResourcesThresholdRule(CeilometerGnocchiAggregationByResourcesThresholdRule ceilometerGnocchiAggregationByResourcesThresholdRule) {
            this.m.gnocchiAggregationByResourcesThresholdRule = ceilometerGnocchiAggregationByResourcesThresholdRule;
            return this;
        }
    }

    public static class CeilometerGnocchiAggregationByResourcesThresholdRule
    implements Alarm.GnocchiAggregationByResourcesThresholdRule {
        @JsonProperty(value="metric")
        String metric;
        @JsonProperty(value="resource_type")
        String resourceType;
        @JsonProperty(value="comparison_operator")
        Alarm.ComparisonOperator comparisonOperator;
        @JsonProperty(value="aggregation_method")
        Alarm.AggregationMethod aggregationMethod;
        @JsonProperty(value="evaluation_periods")
        int evaluationPeriods;
        @JsonProperty(value="threshold")
        float threshold;
        @JsonProperty(value="granularity")
        long granularity;
        @JsonProperty(value="query")
        CeilometerQuery query;

        @Override
        public String getMetric() {
            return this.metric;
        }

        @Override
        public void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public String getResourceType() {
            return this.resourceType;
        }

        @Override
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public Alarm.ComparisonOperator getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public void setComparisonOperator(Alarm.ComparisonOperator comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public Alarm.AggregationMethod getAggregationMethod() {
            return this.aggregationMethod;
        }

        @Override
        public void setAggregationMethod(Alarm.AggregationMethod aggregationMethod) {
            this.aggregationMethod = aggregationMethod;
        }

        @Override
        public int getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public void setEvaluationPeriods(int evaluationPeriod) {
            this.evaluationPeriods = evaluationPeriod;
        }

        @Override
        public float getThreshold() {
            return this.threshold;
        }

        @Override
        public void setThreshold(float threshold) {
            this.threshold = threshold;
        }

        @Override
        public long getGranularity() {
            return this.granularity;
        }

        @Override
        public void setGranularity(long granularity) {
            this.granularity = granularity;
        }

        @Override
        public Alarm.Query getQuery() {
            return this.query;
        }

        @Override
        public void setQuery(CeilometerQuery query) {
            this.query = query;
        }
    }

    public static class CeilometerGnocchiAggregationByMetricsThresholdRule
    implements Alarm.GnocchiAggregationByMetricsThresholdRule {
        @JsonProperty(value="metrics")
        List<String> metrics;
        @JsonProperty(value="comparison_operator")
        Alarm.ComparisonOperator comparisonOperator;
        @JsonProperty(value="aggregation_method")
        Alarm.AggregationMethod aggregationMethod;
        @JsonProperty(value="threshold")
        float threshold;
        @JsonProperty(value="evaluation_periods")
        int evaluationPeriods;
        @JsonProperty(value="granularity")
        long granularity;

        @Override
        public List<String> getMetrics() {
            return this.metrics;
        }

        @Override
        public void setMetrics(List<String> metrics) {
            this.metrics = metrics;
        }

        @Override
        public Alarm.ComparisonOperator getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public void setComparisonOperator(Alarm.ComparisonOperator comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public Alarm.AggregationMethod getAggregationMethod() {
            return this.aggregationMethod;
        }

        @Override
        public void setAggregationMethod(Alarm.AggregationMethod aggregationMethod) {
            this.aggregationMethod = aggregationMethod;
        }

        @Override
        public float getThreshold() {
            return this.threshold;
        }

        @Override
        public void setThreshold(float threshold) {
            this.threshold = threshold;
        }

        @Override
        public int getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public void setEvaluationPeriods(int evaluationPeriod) {
            this.evaluationPeriods = evaluationPeriod;
        }

        @Override
        public long getGranularity() {
            return this.granularity;
        }

        @Override
        public void setGranularity(long granularity) {
            this.granularity = granularity;
        }
    }

    public static class CeilometerGnocchiResourcesThresholdRule
    implements Alarm.GnocchiResourcesThresholdRule {
        @JsonProperty(value="metric")
        String metric;
        @JsonProperty(value="comparison_operator")
        Alarm.ComparisonOperator comparisonOperator;
        @JsonProperty(value="aggregation_method")
        Alarm.AggregationMethod aggregationMethod;
        @JsonProperty(value="evaluation_periods")
        int evaluationPeriods;
        @JsonProperty(value="granularity")
        long granularity;
        @JsonProperty(value="resource_type")
        String resourceType;
        @JsonProperty(value="resource_id")
        String resourceId;
        @JsonProperty(value="threshold")
        float threshold;

        @Override
        public String getMetric() {
            return this.metric;
        }

        @Override
        public void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public String getResourceId() {
            return this.resourceId;
        }

        @Override
        public void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public String getResourceType() {
            return this.resourceType;
        }

        @Override
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public Alarm.ComparisonOperator getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public void setComparisonOperator(Alarm.ComparisonOperator comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public Alarm.AggregationMethod getAggregationMethod() {
            return this.aggregationMethod;
        }

        @Override
        public void setAggregationMethod(Alarm.AggregationMethod aggregationMethod) {
            this.aggregationMethod = aggregationMethod;
        }

        @Override
        public int getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public void setEvaluationPeriods(int evaluationPeriod) {
            this.evaluationPeriods = evaluationPeriod;
        }

        @Override
        public float getThreshold() {
            return this.threshold;
        }

        @Override
        public void setThreshold(float threshold) {
            this.threshold = threshold;
        }

        @Override
        public long getGranularity() {
            return this.granularity;
        }

        @Override
        public void setGranularity(long granularity) {
            this.granularity = granularity;
        }
    }

    public static class CeilometerQuery
    implements Alarm.Query {
        @JsonProperty(value="field")
        String field;
        @JsonProperty(value="value")
        String value;
        @JsonProperty(value="op")
        Alarm.ComparisonOperator op;

        @Override
        public String getField() {
            return this.field;
        }

        @Override
        public void setField(String field) {
            this.field = field;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public Alarm.ComparisonOperator getOp() {
            return this.op;
        }

        @Override
        public void setOp(Alarm.ComparisonOperator comparisonOperator) {
            this.op = comparisonOperator;
        }
    }

    public static class CeilometerThresholdRule
    implements Alarm.ThresholdRule {
        @JsonProperty(value="meter_name")
        String meterName;
        @JsonProperty(value="evaluation_periods")
        int evaluationPeriods;
        @JsonProperty(value="statistic")
        Alarm.Statistic statistic;
        @JsonProperty(value="period")
        int period;
        @JsonProperty(value="threshold")
        float threshold;
        @JsonProperty(value="query")
        List<CeilometerQuery> query;
        @JsonProperty(value="comparison_operator")
        Alarm.ComparisonOperator comparisonOperator;
        @JsonProperty(value="exclude_outliers")
        boolean excludeOutliers;

        @Override
        public String getMeterName() {
            return this.meterName;
        }

        @Override
        public void setMeterName(String meterName) {
            this.meterName = meterName;
        }

        @Override
        public int getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public void setEvaluationPeriods(int evaluationPeriod) {
            this.evaluationPeriods = evaluationPeriod;
        }

        @Override
        public Alarm.Statistic getStatistic() {
            return this.statistic;
        }

        @Override
        public void setStatistic(Alarm.Statistic statistic) {
            this.statistic = statistic;
        }

        @Override
        public int getPeriod() {
            return this.period;
        }

        @Override
        public void setPeriod(int period) {
            this.period = period;
        }

        @Override
        public float getThreshold() {
            return this.threshold;
        }

        @Override
        public void setThreshold(float threshold) {
            this.threshold = threshold;
        }

        @Override
        public List<? extends Alarm.Query> getQuery() {
            return this.query;
        }

        @Override
        public void setQuery(List<CeilometerQuery> query) {
            this.query = query;
        }

        @Override
        public Alarm.ComparisonOperator getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public void setComparisonOperator(Alarm.ComparisonOperator comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public boolean getExcludeOutliers() {
            return this.excludeOutliers;
        }

        @Override
        public void setExcludeOutliers(boolean excludeOutliers) {
            this.excludeOutliers = excludeOutliers;
        }
    }

    public static class CeilometerCombinationRule
    implements Alarm.CombinationRule {
        @JsonProperty(value="alarm_ids")
        List<String> alarmIds;
        @JsonProperty(value="operator")
        Alarm.Operator operator;

        @Override
        public List<String> getAlarmIds() {
            return this.alarmIds;
        }

        @Override
        public void setAlarmIds(List<String> alarmIds) {
            this.alarmIds = alarmIds;
        }

        @Override
        public Alarm.Operator getOperator() {
            return this.operator;
        }

        @Override
        public void setOperator(Alarm.Operator operator) {
            this.operator = operator;
        }
    }
}

