/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.block.internal;

import java.util.Objects;
import org.openstack4j.api.storage.BlockQuotaSetService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.storage.block.BlockQuotaSet;
import org.openstack4j.model.storage.block.BlockQuotaSetUsage;
import org.openstack4j.openstack.storage.block.domain.CinderBlockQuotaSet;
import org.openstack4j.openstack.storage.block.domain.CinderBlockQuotaSetUsage;
import org.openstack4j.openstack.storage.block.internal.BaseBlockStorageServices;

public class BlockQuotaSetServiceImpl
extends BaseBlockStorageServices
implements BlockQuotaSetService {
    @Override
    public BlockQuotaSet getDefaults(String tenantId) {
        Objects.requireNonNull(tenantId, "Tenant cannot be null");
        return this.get(CinderBlockQuotaSet.class, this.uri("/os-quota-sets/%s/defaults", tenantId)).execute();
    }

    @Override
    public BlockQuotaSet get(String tenantId) {
        Objects.requireNonNull(tenantId, "Tenant cannot be null");
        return this.get(CinderBlockQuotaSet.class, this.uri("/os-quota-sets/%s", tenantId)).param("usage", false).execute();
    }

    @Override
    public BlockQuotaSet updateForTenant(String tenantId, BlockQuotaSet quota) {
        Objects.requireNonNull(tenantId, "Tenant cannot be null");
        Objects.requireNonNull(quota, "Quota cannot be null");
        return this.put(CinderBlockQuotaSet.class, this.uri("/os-quota-sets/%s", tenantId)).entity(quota).execute();
    }

    @Override
    public ActionResponse delete(String tenantId) {
        Objects.requireNonNull(tenantId, "Tenant cannot be null");
        return this.delete(ActionResponse.class, this.uri("/os-quota-sets/%s", tenantId)).execute();
    }

    @Override
    public BlockQuotaSetUsage usageForTenant(String tenantId) {
        Objects.requireNonNull(tenantId, "Tenant cannot be null");
        return this.get(CinderBlockQuotaSetUsage.class, this.uri("/os-quota-sets/%s", tenantId)).param("usage", true).execute();
    }

    @Override
    public BlockQuotaSetUsage usageForUser(String tenantId, String userId) {
        Objects.requireNonNull(tenantId, "Tenant cannot be null");
        Objects.requireNonNull(userId, "User cannot be null");
        return this.get(CinderBlockQuotaSetUsage.class, this.uri("/os-quota-sets/%s", tenantId)).param("user_id", userId).param("usage", true).execute();
    }
}

