/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.senlin.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.senlin.SenlinClusterService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.senlin.ActionID;
import org.openstack4j.model.senlin.Cluster;
import org.openstack4j.model.senlin.ClusterActionCreate;
import org.openstack4j.model.senlin.ClusterCreate;
import org.openstack4j.openstack.senlin.domain.SenlinActionID;
import org.openstack4j.openstack.senlin.domain.SenlinCluster;
import org.openstack4j.openstack.senlin.internal.BaseSenlinServices;

public class SenlinClusterServiceImpl
extends BaseSenlinServices
implements SenlinClusterService {
    @Override
    public List<? extends Cluster> list() {
        return this.get(SenlinCluster.Cluster.class, this.uri("/clusters", new Object[0])).execute().getList();
    }

    @Override
    public Cluster get(String clusterID) {
        Objects.requireNonNull(clusterID);
        return this.get(SenlinCluster.class, this.uri("/clusters/%s", clusterID)).execute();
    }

    @Override
    public Cluster create(ClusterCreate newCluster) {
        Objects.requireNonNull(newCluster);
        return this.post(SenlinCluster.class, this.uri("/clusters", new Object[0])).entity(newCluster).execute();
    }

    @Override
    public ActionResponse delete(String clusterID) {
        Objects.requireNonNull(clusterID);
        return this.deleteWithResponse(this.uri("/clusters/%s", clusterID)).execute();
    }

    @Override
    public Cluster update(String clusterID, ClusterCreate newCluster) {
        Objects.requireNonNull(clusterID);
        Objects.requireNonNull(newCluster);
        return this.patch(SenlinCluster.class, this.uri("/clusters/%s", clusterID)).entity(newCluster).execute();
    }

    @Override
    public ActionID action(String clusterID, ClusterActionCreate newClusterAction) {
        Objects.requireNonNull(clusterID);
        Objects.requireNonNull(newClusterAction);
        return this.post(SenlinActionID.class, this.uri("/clusters/%s/actions", clusterID)).entity(newClusterAction).execute();
    }
}

