/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.sahara.ClusterTemplateService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.sahara.ClusterTemplate;
import org.openstack4j.openstack.sahara.domain.SaharaClusterTemplate;
import org.openstack4j.openstack.sahara.domain.SaharaClusterTemplateUnwrapped;
import org.openstack4j.openstack.sahara.internal.BaseSaharaServices;

public class ClusterTemplateServiceImpl
extends BaseSaharaServices
implements ClusterTemplateService {
    @Override
    public List<? extends ClusterTemplate> list() {
        return this.get(SaharaClusterTemplate.ClusterTemplates.class, this.uri("/cluster-templates", new Object[0])).execute().getList();
    }

    @Override
    public ClusterTemplate get(String templateId) {
        Objects.requireNonNull(templateId);
        return this.get(SaharaClusterTemplate.class, this.uri("/cluster-templates/%s", templateId)).execute();
    }

    @Override
    public ClusterTemplate create(ClusterTemplate template) {
        Objects.requireNonNull(template);
        SaharaClusterTemplateUnwrapped unwrapped = new SaharaClusterTemplateUnwrapped(template);
        return this.post(SaharaClusterTemplate.class, this.uri("/cluster-templates", new Object[0])).entity(unwrapped).execute();
    }

    @Override
    public ActionResponse delete(String templateId) {
        Objects.requireNonNull(templateId);
        return this.deleteWithResponse(this.uri("/cluster-templates/%s", templateId)).execute();
    }
}

