/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.sahara.NodeGroupTemplate;
import org.openstack4j.model.sahara.ServiceConfig;
import org.openstack4j.model.sahara.builder.NodeGroupTemplateBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.sahara.domain.SaharaServiceConfig;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="node_group_template")
public class SaharaNodeGroupTemplate
implements NodeGroupTemplate {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    @JsonProperty(value="hadoop_version")
    private String hadoopVersion;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date updatedAt;
    @JsonProperty(value="plugin_name")
    private String pluginName;
    @JsonProperty(value="image_id")
    private String imageId;
    @JsonProperty(value="volumes_size")
    private Integer volumesSize;
    @JsonProperty(value="volumes_per_node")
    private Integer volumesPerNode;
    @JsonProperty(value="floating_ip_pool")
    private String floatingNetworkId;
    @JsonProperty(value="flavor_id")
    private String flavorId;
    @JsonProperty(value="volume_mount_prefix")
    private String volumeMountPrefix;
    @JsonProperty(value="auto_security_group")
    private Boolean autoSecurityGroup;
    @JsonProperty(value="security_groups")
    private List<String> securityGroups;
    @JsonProperty(value="node_processes")
    private List<String> nodeProcesses;
    @JsonProperty(value="node_configs")
    private Map<String, SaharaServiceConfig> serviceConfigs;

    public static NodeGroupTemplateBuilder builder() {
        return new ConcreteNodeGroupTemplateBuilder();
    }

    @Override
    public NodeGroupTemplateBuilder toBuilder() {
        return new ConcreteNodeGroupTemplateBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public String getFloatingNetworkId() {
        return this.floatingNetworkId;
    }

    @Override
    public Integer getVolumesPerNode() {
        return this.volumesPerNode;
    }

    @Override
    public Integer getVolumesSize() {
        return this.volumesSize;
    }

    @Override
    public String getVolumeMountPrefix() {
        return this.volumeMountPrefix;
    }

    @Override
    public String getImageId() {
        return this.imageId;
    }

    @Override
    public String getFlavorId() {
        return this.flavorId;
    }

    @Override
    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    @Override
    public Boolean isAutoSecurityGroup() {
        return this.autoSecurityGroup;
    }

    @Override
    public List<String> getNodeProcesses() {
        return this.nodeProcesses;
    }

    @Override
    public Map<String, ? extends ServiceConfig> getServiceConfigs() {
        return this.serviceConfigs;
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("name", this.name).add("description", this.description).add("hadoop_version", this.hadoopVersion).add("tenant_id", this.tenantId).add("created_at", this.createdAt).add("updated_at", this.updatedAt).add("plugin_name", this.pluginName).add("image_id", this.imageId).add("volumes_size", this.volumesSize).add("volumes_per_node", this.volumesPerNode).add("float_ip_pool", this.floatingNetworkId).add("flavor_id", this.flavorId).add("volume_mount_prefix", this.volumeMountPrefix).add("security_groups", this.securityGroups).add("auto_security_group", this.autoSecurityGroup).add("node_processes", this.nodeProcesses).add("node_configs", this.serviceConfigs).toString();
    }

    public static class ConcreteNodeGroupTemplateBuilder
    implements NodeGroupTemplateBuilder {
        private SaharaNodeGroupTemplate m;

        ConcreteNodeGroupTemplateBuilder() {
            this(new SaharaNodeGroupTemplate());
        }

        ConcreteNodeGroupTemplateBuilder(SaharaNodeGroupTemplate m) {
            this.m = m;
        }

        @Override
        public NodeGroupTemplate build() {
            return this.m;
        }

        @Override
        public NodeGroupTemplateBuilder from(NodeGroupTemplate in) {
            this.m = (SaharaNodeGroupTemplate)in;
            return this;
        }

        @Override
        public NodeGroupTemplateBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public NodeGroupTemplateBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public NodeGroupTemplateBuilder hadoopVersion(String hadoopVersion) {
            this.m.hadoopVersion = hadoopVersion;
            return this;
        }

        @Override
        public NodeGroupTemplateBuilder pluginName(String pluginName) {
            this.m.pluginName = pluginName;
            return this;
        }

        @Override
        public NodeGroupTemplateBuilder floatingIpPool(String networkId) {
            this.m.floatingNetworkId = networkId;
            return this;
        }

        @Override
        public NodeGroupTemplateBuilder flavor(String flavorId) {
            this.m.flavorId = flavorId;
            return this;
        }

        @Override
        public NodeGroupTemplateBuilder setAutoSecurityGroup(boolean isAutoSecurityGroup) {
            this.m.autoSecurityGroup = isAutoSecurityGroup;
            return this;
        }

        @Override
        public NodeGroupTemplateBuilder addSecurityGroup(String id) {
            if (id != null && !id.isEmpty()) {
                if (this.m.securityGroups == null) {
                    this.m.securityGroups = new ArrayList();
                }
                this.m.securityGroups.add(id);
            }
            return this;
        }

        @Override
        public NodeGroupTemplateBuilder addNodeProcess(String name) {
            if (name != null && !name.isEmpty()) {
                if (this.m.nodeProcesses == null) {
                    this.m.nodeProcesses = new ArrayList();
                }
                this.m.nodeProcesses.add(name);
            }
            return this;
        }

        @Override
        public NodeGroupTemplateBuilder addServiceConfig(String name, ServiceConfig config) {
            if (name != null && !name.isEmpty()) {
                if (this.m.serviceConfigs == null) {
                    this.m.serviceConfigs = new HashMap();
                }
                this.m.serviceConfigs.put(name, (SaharaServiceConfig)config);
            }
            return this;
        }
    }

    public static class NodeGroupTemplates
    extends ListResult<SaharaNodeGroupTemplate> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="node_group_templates")
        private List<SaharaNodeGroupTemplate> nodeGroupTemplates;

        @Override
        protected List<SaharaNodeGroupTemplate> value() {
            return this.nodeGroupTemplates;
        }
    }
}

