/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.octavia.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import org.openstack4j.model.octavia.HealthMonitorType;
import org.openstack4j.model.octavia.HealthMonitorV2;
import org.openstack4j.model.octavia.builder.HealthMonitorV2Builder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.octavia.domain.ListItem;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="healthmonitor")
@JsonIgnoreProperties(ignoreUnknown=true)
public class OctaviaHealthMonitorV2
implements HealthMonitorV2 {
    private String id;
    @JsonProperty(value="project_id")
    private String projectId;
    private HealthMonitorType type;
    private Integer delay;
    private Integer timeout;
    @JsonProperty(value="max_retries")
    private Integer maxRetries;
    @JsonProperty(value="max_retries_down")
    private Integer maxRetriesDown;
    @JsonProperty(value="http_method")
    private String httpMethod;
    @JsonProperty(value="url_path")
    private String urlPath;
    @JsonProperty(value="expected_codes")
    private String expectedCodes;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp = true;
    private List<ListItem> pools;
    @JsonProperty(value="pool_id")
    private String poolId;

    public static HealthMonitorV2Builder builder() {
        return new HealthMonitorV2Concretebuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public HealthMonitorType getType() {
        return this.type;
    }

    @Override
    public Integer getDelay() {
        return this.delay;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public Integer getMaxRetriesDown() {
        return this.maxRetriesDown;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public String getUrlPath() {
        return this.urlPath;
    }

    @Override
    public String getExpectedCodes() {
        return this.expectedCodes;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public List<ListItem> getPools() {
        return this.pools;
    }

    @Override
    public HealthMonitorV2Builder toBuilder() {
        return new HealthMonitorV2Concretebuilder(this);
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("projectId", this.projectId).add("type", (Object)this.type).add("delay", this.delay).add("timeout", this.timeout).add("maxRetries", this.maxRetries).add("maxRetriesDown", this.maxRetriesDown).add("httpMethod", this.httpMethod).add("urlPath", this.urlPath).add("expectedCodes", this.expectedCodes).add("adminStateUp", this.adminStateUp).add("pools", this.pools).add("poolId", this.poolId).toString();
    }

    public static class HealthMonitorV2Concretebuilder
    implements HealthMonitorV2Builder {
        OctaviaHealthMonitorV2 m;

        public HealthMonitorV2Concretebuilder() {
            this(new OctaviaHealthMonitorV2());
        }

        public HealthMonitorV2Concretebuilder(OctaviaHealthMonitorV2 m) {
            this.m = m;
        }

        @Override
        public HealthMonitorV2 build() {
            return this.m;
        }

        @Override
        public HealthMonitorV2Builder from(HealthMonitorV2 in) {
            this.m = (OctaviaHealthMonitorV2)in;
            return this;
        }

        @Override
        public HealthMonitorV2Builder projectId(String projectId) {
            this.m.projectId = projectId;
            return this;
        }

        @Override
        public HealthMonitorV2Builder type(HealthMonitorType type) {
            this.m.type = type;
            return this;
        }

        @Override
        public HealthMonitorV2Builder delay(Integer delay) {
            this.m.delay = delay;
            return this;
        }

        @Override
        public HealthMonitorV2Builder timeout(Integer timeout) {
            this.m.timeout = timeout;
            return this;
        }

        @Override
        public HealthMonitorV2Builder maxRetries(Integer maxRetries) {
            this.m.maxRetries = maxRetries;
            return this;
        }

        @Override
        public HealthMonitorV2Builder maxRetriesDown(Integer maxRetriesDown) {
            this.m.maxRetriesDown = maxRetriesDown;
            return this;
        }

        @Override
        public HealthMonitorV2Builder urlPath(String urlPath) {
            this.m.urlPath = urlPath;
            return this;
        }

        @Override
        public HealthMonitorV2Builder expectedCodes(String expectedCodes) {
            this.m.expectedCodes = expectedCodes;
            return this;
        }

        @Override
        public HealthMonitorV2Builder httpMethod(String httpMethod) {
            this.m.httpMethod = httpMethod;
            return this;
        }

        @Override
        public HealthMonitorV2Builder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public HealthMonitorV2Builder poolId(String poolId) {
            this.m.poolId = poolId;
            return this;
        }
    }

    public static class HealthMonitorsV2
    extends ListResult<OctaviaHealthMonitorV2> {
        @JsonProperty(value="healthmonitors")
        List<OctaviaHealthMonitorV2> healthMonitors;

        @Override
        public List<OctaviaHealthMonitorV2> value() {
            return this.healthMonitors;
        }

        public String toString() {
            return new ToStringHelper(this).add("healthMonitors", this.healthMonitors).toString();
        }
    }
}

