/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.networking.ext.NetQosPolicyBLRuleService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.NetQosPolicyBandwidthLimitRule;
import org.openstack4j.openstack.networking.domain.ext.NeutronNetQosPolicyBandwidthLimitRule;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class NetQosPolicyBLRuleServiceImpl
extends BaseNetworkingServices
implements NetQosPolicyBLRuleService {
    @Override
    public List<? extends NetQosPolicyBandwidthLimitRule> list(String policyId) {
        Preconditions.checkNotNull((Object)policyId, (Object)"qos policyId must not be null");
        return this.get(NeutronNetQosPolicyBandwidthLimitRule.NeutronNetQosPolicyBLRules.class, this.uri("/qos/policies/%s/bandwidth_limit_rules", policyId)).execute().getList();
    }

    @Override
    public NetQosPolicyBandwidthLimitRule get(String policyId, String ruleId) {
        Preconditions.checkNotNull((Object)policyId, (Object)"qos policyId must not be null");
        Preconditions.checkNotNull((Object)ruleId, (Object)"qos ruleId must not be null");
        return this.get(NeutronNetQosPolicyBandwidthLimitRule.class, this.uri("/qos/policies/%s/bandwidth_limit_rules/%s", policyId, ruleId)).execute();
    }

    @Override
    public NetQosPolicyBandwidthLimitRule update(String policyId, NetQosPolicyBandwidthLimitRule bandwidthLimitRule) {
        Preconditions.checkNotNull((Object)policyId, (Object)"qos policyId must not be null");
        Preconditions.checkNotNull((Object)bandwidthLimitRule);
        Preconditions.checkNotNull((Object)bandwidthLimitRule.getId(), (Object)"netQosPolicy rule id must not be null");
        return this.put(NeutronNetQosPolicyBandwidthLimitRule.class, this.uri("/qos/policies/%s/bandwidth_limit_rules/%s", policyId, this.getAndClearIdentifier(bandwidthLimitRule))).entity(bandwidthLimitRule).execute();
    }

    @Override
    public NetQosPolicyBandwidthLimitRule create(String policyId, NetQosPolicyBandwidthLimitRule bandwidthLimitRule) {
        Preconditions.checkNotNull((Object)policyId, (Object)"qos policyId must not be null");
        Preconditions.checkNotNull((Object)bandwidthLimitRule, (Object)"netQosPolicy ruleId must not be null");
        return this.post(NeutronNetQosPolicyBandwidthLimitRule.class, this.uri("/qos/policies/%s/bandwidth_limit_rules", policyId)).entity(bandwidthLimitRule).execute();
    }

    @Override
    public ActionResponse delete(String policyId, String ruleId) {
        Preconditions.checkNotNull((Object)policyId, (Object)"qos policyId must not be null");
        Preconditions.checkNotNull((Object)ruleId, (Object)"netQosPolicy ruleId must not be null");
        return this.deleteWithResponse(this.uri("/qos/policies/%s/bandwidth_limit_rules/%s", policyId, ruleId)).execute();
    }

    private String getAndClearIdentifier(NetQosPolicyBandwidthLimitRule update) {
        String id = update.getId();
        update.setId(null);
        return id;
    }
}

