/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.networking.ext.LoadBalancerV2Service;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.LoadBalancerV2;
import org.openstack4j.model.network.ext.LoadBalancerV2Stats;
import org.openstack4j.model.network.ext.LoadBalancerV2StatusTree;
import org.openstack4j.model.network.ext.LoadBalancerV2Update;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.ext.LoadBalancerV2StatusTree.NeutronLoadBalancerV2StatusTree;
import org.openstack4j.openstack.networking.domain.ext.NeutronLoadBalancerV2;
import org.openstack4j.openstack.networking.domain.ext.NeutronLoadBalancerV2Stats;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class LoadBalancerV2ServiceImpl
extends BaseNetworkingServices
implements LoadBalancerV2Service {
    @Override
    public List<? extends LoadBalancerV2> list() {
        return this.get(NeutronLoadBalancerV2.LoadBalancersV2.class, this.uri("/lbaas/loadbalancers", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends LoadBalancerV2> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronLoadBalancerV2.LoadBalancersV2> req = this.get(NeutronLoadBalancerV2.LoadBalancersV2.class, this.uri("/lbaas/loadbalancers", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public LoadBalancerV2 get(String loadbalancerId) {
        Objects.requireNonNull(loadbalancerId);
        return this.get(NeutronLoadBalancerV2.class, this.uri("/lbaas/loadbalancers/%s", loadbalancerId)).execute();
    }

    @Override
    public LoadBalancerV2 create(LoadBalancerV2 loadbalancer) {
        Objects.requireNonNull(loadbalancer);
        return this.post(NeutronLoadBalancerV2.class, this.uri("/lbaas/loadbalancers", new Object[0])).entity(loadbalancer).execute();
    }

    @Override
    public LoadBalancerV2 update(String loadbalancerId, LoadBalancerV2Update loadbalancer) {
        Objects.requireNonNull(loadbalancerId);
        Objects.requireNonNull(loadbalancer);
        return this.put(NeutronLoadBalancerV2.class, this.uri("/lbaas/loadbalancers/%s", loadbalancerId)).entity(loadbalancer).execute();
    }

    @Override
    public ActionResponse delete(String loadbalancerId) {
        Objects.requireNonNull(loadbalancerId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lbaas/loadbalancers/%s", loadbalancerId)).executeWithResponse());
    }

    @Override
    public LoadBalancerV2Stats stats(String loadbalancerId) {
        Objects.requireNonNull(loadbalancerId);
        return this.get(NeutronLoadBalancerV2Stats.class, this.uri("/lbaas/loadbalancers/%s/stats", loadbalancerId)).execute();
    }

    @Override
    public LoadBalancerV2StatusTree statusTree(String loadbalancerId) {
        Objects.requireNonNull(loadbalancerId);
        return this.get(NeutronLoadBalancerV2StatusTree.class, this.uri("/lbaas/loadbalancers/%s/statuses", loadbalancerId)).execute();
    }
}

