/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.networking.ext.HealthMonitorV2Service;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.HealthMonitorV2;
import org.openstack4j.model.network.ext.HealthMonitorV2Update;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.ext.NeutronHealthMonitorV2;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class HealthMonitorV2ServiceImpl
extends BaseNetworkingServices
implements HealthMonitorV2Service {
    @Override
    public List<? extends HealthMonitorV2> list() {
        return this.get(NeutronHealthMonitorV2.HealthMonitorsV2.class, this.uri("/lbaas/healthmonitors", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends HealthMonitorV2> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronHealthMonitorV2.HealthMonitorsV2> req = this.get(NeutronHealthMonitorV2.HealthMonitorsV2.class, this.uri("/lbaas/healthmonitors", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public HealthMonitorV2 get(String healthMonitorId) {
        Objects.requireNonNull(healthMonitorId);
        return this.get(NeutronHealthMonitorV2.class, this.uri("/lbaas/healthmonitors/%s", healthMonitorId)).execute();
    }

    @Override
    public ActionResponse delete(String healthMonitorId) {
        Objects.requireNonNull(healthMonitorId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lbaas/healthmonitors/%s", healthMonitorId)).executeWithResponse());
    }

    @Override
    public HealthMonitorV2 create(HealthMonitorV2 healthMonitor) {
        Objects.requireNonNull(healthMonitor);
        return this.post(NeutronHealthMonitorV2.class, this.uri("/lbaas/healthmonitors", new Object[0])).entity(healthMonitor).execute();
    }

    @Override
    public HealthMonitorV2 update(String healthMonitorId, HealthMonitorV2Update healthMonitor) {
        Objects.requireNonNull(healthMonitorId);
        Objects.requireNonNull(healthMonitor);
        return this.put(NeutronHealthMonitorV2.class, this.uri("/lbaas/healthmonitors/%s", healthMonitorId)).entity(healthMonitor).execute();
    }
}

