/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.networking.ext.FirewallPolicyService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.FirewallPolicy;
import org.openstack4j.model.network.ext.FirewallPolicyUpdate;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.ext.AbstractNeutronFirewallPolicy;
import org.openstack4j.openstack.networking.domain.ext.FirewallRuleStrategy;
import org.openstack4j.openstack.networking.domain.ext.NeutronFirewallPolicy;
import org.openstack4j.openstack.networking.domain.ext.NeutronFirewallPolicyRule;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class FirewallPolicyServiceImpl
extends BaseNetworkingServices
implements FirewallPolicyService {
    @Override
    public List<? extends FirewallPolicy> list() {
        return this.get(AbstractNeutronFirewallPolicy.FirewallPolicies.class, this.uri("/fw/firewall_policies", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends FirewallPolicy> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<AbstractNeutronFirewallPolicy.FirewallPolicies> req = this.get(AbstractNeutronFirewallPolicy.FirewallPolicies.class, this.uri("/fw/firewall_policies", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public FirewallPolicy get(String firewallPolicyId) {
        Objects.requireNonNull(firewallPolicyId);
        return this.get(NeutronFirewallPolicy.class, this.uri("/fw/firewall_policies/%s", firewallPolicyId)).execute();
    }

    @Override
    public ActionResponse delete(String firewallPolicyId) {
        Objects.requireNonNull(firewallPolicyId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/fw/firewall_policies/%s", firewallPolicyId)).executeWithResponse());
    }

    @Override
    public FirewallPolicy create(FirewallPolicy firewallPolicy) {
        return this.post(NeutronFirewallPolicy.class, this.uri("/fw/firewall_policies", new Object[0])).entity(firewallPolicy).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public FirewallPolicy update(String firewallPolicyId, FirewallPolicyUpdate firewallPolicyUpdate) {
        Objects.requireNonNull(firewallPolicyId);
        Objects.requireNonNull(firewallPolicyUpdate);
        return this.put(NeutronFirewallPolicy.class, this.uri("/fw/firewall_policies/%s", firewallPolicyId)).entity(firewallPolicyUpdate).execute();
    }

    @Override
    public FirewallPolicy insertFirewallRuleInPolicy(String firewallPolicyId, String firewallRuleId, FirewallRuleStrategy.RuleInsertStrategyType type, String insertAfterOrBeforeRuleId) {
        Objects.requireNonNull(firewallPolicyId);
        Objects.requireNonNull(firewallRuleId);
        return this.put(NeutronFirewallPolicyRule.class, this.uri("/fw/firewall_policies/%s/insert_rule", firewallPolicyId)).entity(FirewallRuleStrategy.create(firewallRuleId, type, insertAfterOrBeforeRuleId)).execute();
    }

    @Override
    public FirewallPolicy removeFirewallRuleFromPolicy(String firewallPolicyId, String firewallRuleId) {
        Objects.requireNonNull(firewallPolicyId);
        Objects.requireNonNull(firewallRuleId);
        return this.put(NeutronFirewallPolicyRule.class, this.uri("/fw/firewall_policies/%s/remove_rule", firewallPolicyId)).entity(FirewallRuleStrategy.remove(firewallRuleId)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }
}

