/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.networking.SubnetService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.openstack.networking.domain.NeutronSubnet;
import org.openstack4j.openstack.networking.domain.NeutronSubnetUpdate;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class SubnetServiceImpl
extends BaseNetworkingServices
implements SubnetService {
    @Override
    public List<? extends Subnet> list() {
        return this.get(NeutronSubnet.Subnets.class, this.uri("/subnets", new Object[0])).execute().getList();
    }

    @Override
    public Subnet get(String subnetId) {
        Objects.requireNonNull(subnetId);
        return this.get(NeutronSubnet.class, this.uri("/subnets/%s", subnetId)).execute();
    }

    @Override
    public ActionResponse delete(String subnetId) {
        Objects.requireNonNull(subnetId);
        return this.deleteWithResponse(this.uri("/subnets/%s", subnetId)).execute();
    }

    @Override
    public Subnet create(Subnet subnet) {
        Objects.requireNonNull(subnet);
        return this.post(NeutronSubnet.class, this.uri("/subnets", new Object[0])).entity(subnet).execute();
    }

    @Override
    public Subnet update(Subnet subnet) {
        Objects.requireNonNull(subnet);
        return this.update(subnet.getId(), subnet);
    }

    @Override
    public Subnet update(String subnetId, Subnet subnet) {
        Objects.requireNonNull(subnetId);
        Objects.requireNonNull(subnet);
        return this.put(NeutronSubnet.class, this.uri("/subnets/%s", subnetId)).entity(NeutronSubnetUpdate.createFromSubnet(subnet)).execute();
    }
}

