/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import org.openstack4j.model.network.ext.HealthMonitor;
import org.openstack4j.model.network.ext.HealthMonitorType;
import org.openstack4j.model.network.ext.builder.HealthMonitorBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="health_monitor")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronHealthMonitor
implements HealthMonitor {
    private static final long serialVersionUID = 1L;
    private String id;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private HealthMonitorType type;
    private Integer delay;
    private Integer timeout;
    @JsonProperty(value="max_retries")
    private Integer maxRetries;
    @JsonProperty(value="http_method")
    private String httpMethod;
    @JsonProperty(value="url_path")
    private String urlPath;
    @JsonProperty(value="expected_codes")
    private String expectedCodes;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp;
    private String status;

    public static HealthMonitorBuilder builder() {
        return new HealthMonitorConcretebuilder();
    }

    @Override
    public HealthMonitorBuilder toBuilder() {
        return new HealthMonitorConcretebuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public HealthMonitorType getType() {
        return this.type;
    }

    @Override
    public Integer getDelay() {
        return this.delay;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public String getUrlPath() {
        return this.urlPath;
    }

    @Override
    public String getExpectedCodes() {
        return this.expectedCodes;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("adminStateUp", this.adminStateUp).add("delay", this.delay).add("expectedCodes", this.expectedCodes).add("httpMethod", this.httpMethod).add("maxRetries", this.maxRetries).add("status", this.status).add("tenantId", this.tenantId).add("timeout", this.timeout).add("type", (Object)this.type).add("urlPath", this.urlPath).toString();
    }

    public static class HealthMonitorConcretebuilder
    implements HealthMonitorBuilder {
        NeutronHealthMonitor m;

        public HealthMonitorConcretebuilder() {
            this(new NeutronHealthMonitor());
        }

        public HealthMonitorConcretebuilder(NeutronHealthMonitor m) {
            this.m = m;
        }

        @Override
        public HealthMonitor build() {
            return this.m;
        }

        @Override
        public HealthMonitorBuilder from(HealthMonitor in) {
            this.m = (NeutronHealthMonitor)in;
            return this;
        }

        @Override
        public HealthMonitorBuilder tenantId(String tenantId) {
            this.m.tenantId = tenantId;
            return this;
        }

        @Override
        public HealthMonitorBuilder type(HealthMonitorType type) {
            this.m.type = type;
            return this;
        }

        @Override
        public HealthMonitorBuilder delay(Integer delay) {
            this.m.delay = delay;
            return this;
        }

        @Override
        public HealthMonitorBuilder timeout(Integer timeout) {
            this.m.timeout = timeout;
            return this;
        }

        @Override
        public HealthMonitorBuilder maxRetries(Integer maxRetries) {
            this.m.maxRetries = maxRetries;
            return this;
        }

        @Override
        public HealthMonitorBuilder urlPath(String urlPath) {
            this.m.urlPath = urlPath;
            return this;
        }

        @Override
        public HealthMonitorBuilder expectedCodes(String expectedCodes) {
            this.m.expectedCodes = expectedCodes;
            return this;
        }

        @Override
        public HealthMonitorBuilder httpMethod(String httpMethod) {
            this.m.httpMethod = httpMethod;
            return this;
        }

        @Override
        public HealthMonitorBuilder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }
    }

    public static class HealthMonitors
    extends ListResult<NeutronHealthMonitor> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="health_monitors")
        List<NeutronHealthMonitor> healthMonitors;

        @Override
        public List<NeutronHealthMonitor> value() {
            return this.healthMonitors;
        }

        public String toString() {
            return new ToStringHelper(this).add("healthMonitors", this.healthMonitors).toString();
        }
    }
}

