/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.network.TrunkSubport;
import org.openstack4j.openstack.common.ListEntity;

@JsonRootName(value="sub_ports")
public class NeutronTrunkSubportCreate
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="port_id")
    private String portId;
    @JsonProperty(value="segmentation_id")
    private int segmentationId;
    @JsonProperty(value="segmentation_type")
    private String segmentationType;

    public static NeutronTrunkSubportCreate fromTrunkSubport(TrunkSubport trunkSubport) {
        NeutronTrunkSubportCreate toCreate = new NeutronTrunkSubportCreate();
        toCreate.segmentationId = trunkSubport.getSegmentationId();
        toCreate.segmentationType = trunkSubport.getSegmentationType();
        toCreate.portId = trunkSubport.getPortId();
        return toCreate;
    }

    public static class NeutronTrunkSubportsCreate
    implements ModelEntity {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="sub_ports")
        private ListEntity<NeutronTrunkSubportCreate> trunkSubports = new ListEntity();

        public static NeutronTrunkSubportsCreate fromTrunkSubports(List<? extends TrunkSubport> trunkSubports) {
            NeutronTrunkSubportsCreate toCreate = new NeutronTrunkSubportsCreate();
            for (TrunkSubport trunkSubport : trunkSubports) {
                toCreate.trunkSubports.add(NeutronTrunkSubportCreate.fromTrunkSubport(trunkSubport));
            }
            return toCreate;
        }
    }

    public static class NeutronTrunkSubportDelete
    implements ModelEntity {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="port_id")
        private String portId;

        public static NeutronTrunkSubportDelete delete(String portId) {
            NeutronTrunkSubportDelete toDelete = new NeutronTrunkSubportDelete();
            toDelete.portId = portId;
            return toDelete;
        }

        public static class NeutronTrunkSubportsDelete
        implements ModelEntity {
            private static final long serialVersionUID = 1L;
            @JsonProperty(value="sub_ports")
            private ListEntity<NeutronTrunkSubportDelete> trunkSubports = new ListEntity();

            public static NeutronTrunkSubportsDelete delete(List<String> portIds) {
                NeutronTrunkSubportsDelete toDelete = new NeutronTrunkSubportsDelete();
                for (String portId : portIds) {
                    toDelete.trunkSubports.add(NeutronTrunkSubportDelete.delete(portId));
                }
                return toDelete;
            }
        }
    }
}

