/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.openstack4j.model.common.builder.ResourceBuilder;
import org.openstack4j.model.network.HostRoute;
import org.openstack4j.model.network.IPVersionType;
import org.openstack4j.model.network.Ipv6AddressMode;
import org.openstack4j.model.network.Ipv6RaMode;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.Pool;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.model.network.builder.SubnetBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.networking.domain.NeutronHostRoute;
import org.openstack4j.openstack.networking.domain.NeutronPool;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="subnet")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronSubnet
implements Subnet {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    @JsonProperty(value="enable_dhcp")
    private boolean enableDHCP;
    @JsonProperty(value="network_id")
    private String networkId;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="dns_nameservers")
    private List<String> dnsNames;
    @JsonProperty(value="allocation_pools")
    private List<NeutronPool> pools;
    @JsonProperty(value="host_routes")
    private List<NeutronHostRoute> hostRoutes;
    @JsonProperty(value="ip_version")
    private IPVersionType ipVersion;
    @JsonProperty(value="gateway_ip")
    private String gateway;
    private String cidr;
    @JsonProperty(value="ipv6_address_mode")
    private Ipv6AddressMode ipv6AddressMode;
    @JsonProperty(value="ipv6_ra_mode")
    private Ipv6RaMode ipv6RaMode;
    @JsonProperty(value="created_at")
    private Date createdTime;
    @JsonProperty(value="updated_at")
    private Date updatedTime;

    public NeutronSubnet() {
    }

    public NeutronSubnet(String id, String name, boolean enableDHCP, String networkId, String tenantId, List<String> dnsNames, List<NeutronPool> pools, List<NeutronHostRoute> hostRoutes, IPVersionType ipVersion, String gateway, String cidr, Ipv6AddressMode ipv6AddressMode, Ipv6RaMode ipv6RaMode) {
        this.id = id;
        this.name = name;
        this.enableDHCP = enableDHCP;
        this.networkId = networkId;
        this.tenantId = tenantId;
        this.dnsNames = dnsNames;
        this.pools = pools;
        this.hostRoutes = hostRoutes;
        this.ipVersion = ipVersion;
        this.gateway = gateway;
        this.cidr = cidr;
        this.ipv6AddressMode = ipv6AddressMode;
        this.ipv6RaMode = ipv6RaMode;
    }

    public static SubnetBuilder builder() {
        return new SubnetConcreteBuilder();
    }

    @Override
    public SubnetBuilder toBuilder() {
        return new SubnetConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public boolean isDHCPEnabled() {
        return this.enableDHCP;
    }

    @Override
    public String getNetworkId() {
        return this.networkId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    @Override
    @JsonIgnore
    public List<? extends Pool> getAllocationPools() {
        return this.pools;
    }

    @Override
    public List<? extends HostRoute> getHostRoutes() {
        return this.hostRoutes;
    }

    @Override
    public IPVersionType getIpVersion() {
        return this.ipVersion;
    }

    @Override
    public String getGateway() {
        return this.gateway;
    }

    @Override
    public String getCidr() {
        return this.cidr;
    }

    @Override
    public Ipv6AddressMode getIpv6AddressMode() {
        return this.ipv6AddressMode;
    }

    @Override
    public Ipv6RaMode getIpv6RaMode() {
        return this.ipv6RaMode;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("name", this.name).add("enableDHCP", this.enableDHCP).add("network-id", this.networkId).add("tenant_id", this.tenantId).add("dns_nameservers", this.dnsNames).add("allocation_pools", this.pools).add("host_routes", this.hostRoutes).add("ip_version", (Object)this.ipVersion).add("gateway_ip", this.gateway).add("cidr", this.cidr).add("ipv6AddressMode", (Object)this.ipv6AddressMode).add("ipv6RaMode", (Object)this.ipv6RaMode).add("created_at", this.createdTime).add("updated_at", this.updatedTime).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.enableDHCP, this.networkId, this.tenantId, this.dnsNames, this.pools, this.hostRoutes, this.ipVersion, this.gateway, this.cidr, this.ipv6AddressMode, this.ipv6RaMode, this.createdTime, this.updatedTime});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NeutronSubnet) {
            NeutronSubnet that = (NeutronSubnet)obj;
            if (Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.enableDHCP, that.enableDHCP) && Objects.equals(this.networkId, that.networkId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.dnsNames, that.dnsNames) && Objects.equals(this.pools, that.pools) && Objects.equals(this.hostRoutes, that.hostRoutes) && Objects.equals((Object)this.ipVersion, (Object)that.ipVersion) && Objects.equals(this.gateway, that.gateway) && Objects.equals(this.cidr, that.cidr) && Objects.equals((Object)this.ipv6AddressMode, (Object)that.ipv6AddressMode) && Objects.equals((Object)this.ipv6RaMode, (Object)that.ipv6RaMode) && Objects.equals(this.createdTime, that.createdTime) && Objects.equals(this.updatedTime, that.updatedTime)) {
                return true;
            }
        }
        return false;
    }

    public static class SubnetConcreteBuilder
    extends ResourceBuilder<Subnet, SubnetConcreteBuilder>
    implements SubnetBuilder {
        private NeutronSubnet m;
        private boolean isNoGateway = false;

        SubnetConcreteBuilder() {
            this(new NeutronSubnet());
        }

        SubnetConcreteBuilder(NeutronSubnet m) {
            this.m = m;
        }

        @Override
        public SubnetBuilder networkId(String networkId) {
            this.m.networkId = networkId;
            return this;
        }

        @Override
        public SubnetBuilder network(Network network) {
            this.m.networkId = network.getId();
            return this;
        }

        @Override
        public SubnetBuilder ipVersion(IPVersionType ipVersion) {
            this.m.ipVersion = ipVersion;
            return this;
        }

        @Override
        public SubnetBuilder cidr(String cidr) {
            this.m.cidr = cidr;
            return this;
        }

        @Override
        public SubnetBuilder gateway(String gateway) {
            this.m.gateway = gateway;
            return this;
        }

        @Override
        public SubnetBuilder addPool(String start, String end) {
            if (this.m.pools == null) {
                this.m.pools = new ArrayList();
            }
            this.m.pools.add(new NeutronPool(start, end));
            return this;
        }

        @Override
        public SubnetBuilder enableDHCP(boolean enable) {
            this.m.enableDHCP = enable;
            return this;
        }

        @Override
        public SubnetBuilder noGateway() {
            this.isNoGateway = true;
            return this;
        }

        @Override
        public SubnetBuilder ipv6AddressMode(Ipv6AddressMode ipv6AddressMode) {
            this.m.ipv6AddressMode = ipv6AddressMode;
            return this;
        }

        @Override
        public SubnetBuilder ipv6RaMode(Ipv6RaMode ipv6RaMode) {
            this.m.ipv6RaMode = ipv6RaMode;
            return this;
        }

        @Override
        public Subnet build() {
            if (this.isNoGateway) {
                return new NeutronSubnetNoGateway(this.m.id, this.m.name, this.m.enableDHCP, this.m.networkId, this.m.tenantId, this.m.dnsNames, this.m.pools, this.m.hostRoutes, this.m.ipVersion, this.m.cidr, this.m.ipv6AddressMode, this.m.ipv6RaMode);
            }
            return this.m;
        }

        @Override
        public SubnetBuilder from(Subnet in) {
            return this;
        }

        @Override
        protected Subnet reference() {
            return this.m;
        }

        @Override
        public SubnetBuilder addDNSNameServer(String host) {
            if (host == null || host.isEmpty()) {
                return this;
            }
            if (this.m.dnsNames == null) {
                this.m.dnsNames = new ArrayList();
            }
            this.m.dnsNames.add(host);
            return this;
        }

        @Override
        public SubnetBuilder addHostRoute(String destination, String nexthop) {
            if (nexthop == null || destination == null) {
                throw new IllegalArgumentException("NextHop and Destination must have a value");
            }
            if (this.m.hostRoutes == null) {
                this.m.hostRoutes = new ArrayList();
            }
            this.m.hostRoutes.add(new NeutronHostRoute(destination, nexthop));
            return this;
        }
    }

    public static class Subnets
    extends ListResult<NeutronSubnet> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="subnets")
        private List<NeutronSubnet> subnets;

        @Override
        protected List<NeutronSubnet> value() {
            return this.subnets;
        }
    }

    @JsonRootName(value="subnet")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NeutronSubnetNoGateway
    extends NeutronSubnet {
        @JsonProperty(value="gateway_ip")
        @JsonInclude
        private String gateway = null;

        public NeutronSubnetNoGateway(String id, String name, boolean enableDHCP, String networkId, String tenantId, List<String> dnsNames, List<NeutronPool> pools, List<NeutronHostRoute> hostRoutes, IPVersionType ipVersion, String cidr, Ipv6AddressMode ipv6AddressMode, Ipv6RaMode ipv6RaMode) {
            super(id, name, enableDHCP, networkId, tenantId, dnsNames, pools, hostRoutes, ipVersion, null, cidr, ipv6AddressMode, ipv6RaMode);
        }
    }
}

