/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.model.network.builder.NetFloatingIPBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="floatingip")
public class NeutronFloatingIP
implements NetFloatingIP {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="router_id")
    private String routerId;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonProperty(value="floating_network_id")
    private String floatingNetworkId;
    @JsonProperty(value="floating_ip_address")
    private String floatingIpAddress;
    @JsonProperty(value="fixed_ip_address")
    private String fixedIpAddress;
    @JsonProperty(value="port_id")
    private String portId;
    @JsonProperty(value="qos_policy_id")
    private String qosPolicyId;
    private String status;
    private String description;
    private List<String> tags;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    private Date updatedAt;
    @JsonProperty(value="revision_number")
    private Integer revisionNumber;

    public static NetFloatingIPBuilder builder() {
        return new FloatingIPConcreteBuilder();
    }

    @Override
    public NetFloatingIPBuilder toBuilder() {
        return new FloatingIPConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouterId() {
        return this.routerId;
    }

    public void setRouterId(String routerId) {
        this.routerId = routerId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getFloatingNetworkId() {
        return this.floatingNetworkId;
    }

    public void setFloatingNetworkId(String floatingNetworkId) {
        this.floatingNetworkId = floatingNetworkId;
    }

    @Override
    public String getFloatingIpAddress() {
        return this.floatingIpAddress;
    }

    public void setFloatingIpAddress(String floatingIpAddress) {
        this.floatingIpAddress = floatingIpAddress;
    }

    @Override
    public String getFixedIpAddress() {
        return this.fixedIpAddress;
    }

    public void setFixedIpAddress(String fixedIpAddress) {
        this.fixedIpAddress = fixedIpAddress;
    }

    @Override
    public String getPortId() {
        return this.portId;
    }

    public void setPortId(String portId) {
        this.portId = portId;
    }

    @Override
    public String getQosPolicyId() {
        return this.qosPolicyId;
    }

    @Override
    public Integer getRevisionNumber() {
        return this.revisionNumber;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String toString() {
        String distinctTenantId = Objects.equals(this.tenantId, this.projectId) ? null : this.tenantId;
        return new ToStringHelper(this).add("id", this.id).add("routerId", this.routerId).add("floatingNetworkId", this.floatingNetworkId).add("projectId", this.projectId).add("tenantId", distinctTenantId).add("floatingIpAddress", this.floatingIpAddress).add("fixedIpAddress", this.fixedIpAddress).add("portId", this.portId).add("status", this.status).toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.routerId, this.tenantId, this.projectId, this.floatingNetworkId, this.floatingIpAddress, this.fixedIpAddress, this.portId, this.qosPolicyId, this.status, this.description, this.tags, this.createdAt, this.updatedAt, this.revisionNumber);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NeutronFloatingIP that = (NeutronFloatingIP)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.routerId, that.routerId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.projectId, that.projectId) && Objects.equals(this.floatingNetworkId, that.floatingNetworkId) && Objects.equals(this.floatingIpAddress, that.floatingIpAddress) && Objects.equals(this.fixedIpAddress, that.fixedIpAddress) && Objects.equals(this.portId, that.portId) && Objects.equals(this.qosPolicyId, that.qosPolicyId) && Objects.equals(this.status, that.status) && Objects.equals(this.description, that.description) && Objects.equals(this.tags, that.tags) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.updatedAt, that.updatedAt) && Objects.equals(this.revisionNumber, that.revisionNumber);
    }

    public static class FloatingIPConcreteBuilder
    implements NetFloatingIPBuilder {
        private NeutronFloatingIP f = null;

        public FloatingIPConcreteBuilder() {
            this.f = new NeutronFloatingIP();
        }

        public FloatingIPConcreteBuilder(NetFloatingIP in) {
            this.f = (NeutronFloatingIP)in;
        }

        @Override
        public NetFloatingIP build() {
            return this.f;
        }

        @Override
        public NetFloatingIPBuilder from(NetFloatingIP in) {
            this.f = (NeutronFloatingIP)in;
            return this;
        }

        @Override
        public NetFloatingIPBuilder floatingNetworkId(String networkId) {
            this.f.floatingNetworkId = networkId;
            return this;
        }

        @Override
        public NetFloatingIPBuilder portId(String portId) {
            this.f.portId = portId;
            return this;
        }

        @Override
        public NetFloatingIPBuilder floatingIpAddress(String address) {
            this.f.floatingIpAddress = address;
            return this;
        }

        @Override
        public NetFloatingIPBuilder fixedIpAddress(String address) {
            this.f.fixedIpAddress = address;
            return this;
        }

        @Override
        public NetFloatingIPBuilder description(String description) {
            this.f.description = description;
            return this;
        }
    }

    public static class FloatingIPs
    extends ListResult<NeutronFloatingIP> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="floatingips")
        private List<NeutronFloatingIP> floatingIps;

        @Override
        protected List<NeutronFloatingIP> value() {
            return this.floatingIps;
        }
    }
}

