/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.murano.v1.internal;

import java.util.Objects;
import org.openstack4j.api.murano.v1.MuranoSessionService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.openstack.murano.v1.domain.MuranoSession;
import org.openstack4j.openstack.murano.v1.internal.BaseMuranoServices;

public class MuranoSessionServiceImpl
extends BaseMuranoServices
implements MuranoSessionService {
    @Override
    public MuranoSession get(String environmentId, String sessionId) {
        Objects.requireNonNull(environmentId);
        Objects.requireNonNull(sessionId);
        return this.get(MuranoSession.class, this.uri("/environments/%s/sessions/%s", environmentId, sessionId)).execute();
    }

    @Override
    public MuranoSession configure(String environmentId) {
        Objects.requireNonNull(environmentId);
        return this.post(MuranoSession.class, this.uri("/environments/%s/configure", environmentId)).execute();
    }

    @Override
    public ActionResponse delete(String environmentId, String sessionId) {
        Objects.requireNonNull(environmentId);
        Objects.requireNonNull(sessionId);
        return this.deleteWithResponse(this.uri("/environments/%s/sessions/%s", environmentId, sessionId)).execute();
    }

    @Override
    public ActionResponse deploy(String environmentId, String sessionId) {
        Objects.requireNonNull(environmentId);
        Objects.requireNonNull(sessionId);
        return this.post(ActionResponse.class, this.uri("/environments/%s/sessions/%s/deploy", environmentId, sessionId)).execute();
    }
}

