/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.murano.v1.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.openstack4j.model.murano.v1.builder.EnvironmentBuilder;
import org.openstack4j.model.murano.v1.domain.Environment;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.murano.v1.domain.MuranoApplication;
import org.openstack4j.util.ToStringHelper;

public class MuranoEnvironment
implements Environment {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String status;
    @JsonProperty
    private String updated;
    @JsonProperty
    private String created;
    @JsonProperty
    private String version;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private List<MuranoApplication> services;

    public static EnvironmentBuilder builder() {
        return new MuranoEnvironmentConcreteBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<MuranoApplication> getServices() {
        return this.services;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getUpdated() {
        return this.updated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCreated() {
        return this.created;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("name", this.name).add("status", this.status).add("created", this.created).add("updated", this.updated).add("tenant_id", this.tenantId).add("version", this.version).toString();
    }

    @Override
    public EnvironmentBuilder toBuilder() {
        return new MuranoEnvironmentConcreteBuilder(this);
    }

    public static class MuranoEnvironments
    extends ListResult<MuranoEnvironment> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="environments")
        protected List<MuranoEnvironment> list;

        @Override
        protected List<MuranoEnvironment> value() {
            return this.list;
        }
    }

    public static class MuranoEnvironmentConcreteBuilder
    implements EnvironmentBuilder {
        private MuranoEnvironment model;

        MuranoEnvironmentConcreteBuilder() {
            this(new MuranoEnvironment());
        }

        MuranoEnvironmentConcreteBuilder(MuranoEnvironment model) {
            this.model = model;
        }

        @Override
        public EnvironmentBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public Environment build() {
            return this.model;
        }

        @Override
        public EnvironmentBuilder from(Environment in) {
            if (in != null) {
                this.model = (MuranoEnvironment)in;
            }
            return this;
        }
    }
}

