/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.manila.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.openstack4j.api.manila.ShareTypeService;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.manila.ExtraSpecs;
import org.openstack4j.model.manila.ShareType;
import org.openstack4j.model.manila.ShareTypeAccess;
import org.openstack4j.model.manila.ShareTypeCreate;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.manila.domain.ManilaShareType;
import org.openstack4j.openstack.manila.domain.actions.ShareTypeAction;
import org.openstack4j.openstack.manila.domain.actions.ShareTypeActions;
import org.openstack4j.openstack.manila.internal.BaseShareServices;

public class ShareTypeServiceImpl
extends BaseShareServices
implements ShareTypeService {
    @Override
    public ShareType create(ShareTypeCreate shareTypeCreate) {
        Objects.requireNonNull(shareTypeCreate);
        return this.post(ShareVolumeTypeWrapper.class, this.uri("/types", new Object[0])).entity(shareTypeCreate).execute().shareType;
    }

    @Override
    public List<? extends ShareType> list() {
        return this.get(ManilaShareType.ShareTypes.class, this.uri("/types", new Object[0])).execute().getList();
    }

    @Override
    public ShareType listDefaults() {
        return this.get(ShareVolumeTypeWrapper.class, this.uri("/types/default", new Object[0])).execute().shareType;
    }

    @Override
    public ActionResponse delete(String shareTypeId) {
        Objects.requireNonNull(shareTypeId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/types/%s", shareTypeId)).executeWithResponse());
    }

    @Override
    public ExtraSpecs listExtraSpecs(String shareTypeId) {
        Objects.requireNonNull(shareTypeId);
        return this.get(ExtraSpecs.class, this.uri("/types/%s/extra_specs", shareTypeId)).execute();
    }

    @Override
    public ExtraSpecs setExtraSpec(String shareTypeId, ExtraSpecs extraSpecs) {
        Objects.requireNonNull(shareTypeId);
        Objects.requireNonNull(extraSpecs);
        return this.post(ExtraSpecs.class, this.uri("/types/%s/extra_specs", shareTypeId)).entity(extraSpecs).execute();
    }

    @Override
    public ActionResponse unsetExtraSpec(String shareTypeId, String extraSpecKey) {
        Objects.requireNonNull(shareTypeId);
        Objects.requireNonNull(extraSpecKey);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/types/%s/extra_specs/%s", shareTypeId, extraSpecKey)).executeWithResponse());
    }

    @Override
    public ActionResponse addShareTypeAccess(String shareTypeId, String projectId) {
        Objects.requireNonNull(shareTypeId);
        Objects.requireNonNull(projectId);
        return this.invokeAction(shareTypeId, ShareTypeActions.addShareTypeAccess(projectId));
    }

    @Override
    public ActionResponse removeShareTypeAccess(String shareTypeId, String projectId) {
        Objects.requireNonNull(shareTypeId);
        Objects.requireNonNull(projectId);
        return this.invokeAction(shareTypeId, ShareTypeActions.removeShareTypeAccess(projectId));
    }

    private ActionResponse invokeAction(String shareTypeId, ShareTypeAction action) {
        return ToActionResponseFunction.INSTANCE.apply(this.post(Void.class, this.uri("/types/%s/action", shareTypeId)).entity(action).executeWithResponse());
    }

    @Override
    public List<? extends ShareTypeAccess> shareTypeAccessDetails(String shareTypeId) {
        Objects.requireNonNull(shareTypeId);
        return this.get(ShareTypeAccess.ShareTypeAccessList.class, this.uri("/types/%s/os-share-type-access", shareTypeId)).execute().getList();
    }

    private static class ShareVolumeTypeWrapper
    implements ModelEntity {
        @JsonProperty(value="volume_type")
        private ManilaShareType volumeType;
        @JsonProperty(value="share_type")
        private ManilaShareType shareType;

        private ShareVolumeTypeWrapper() {
        }
    }
}

