/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.manila.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.manila.ShareSnapshotService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.manila.ShareSnapshot;
import org.openstack4j.model.manila.ShareSnapshotCreate;
import org.openstack4j.model.manila.ShareSnapshotUpdateOptions;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.manila.domain.ManilaShareSnapshot;
import org.openstack4j.openstack.manila.domain.ManilaShareSnapshotUpdate;
import org.openstack4j.openstack.manila.domain.actions.ShareSnapshotAction;
import org.openstack4j.openstack.manila.domain.actions.ShareSnapshotActions;
import org.openstack4j.openstack.manila.internal.BaseShareServices;

public class ShareSnapshotServiceImpl
extends BaseShareServices
implements ShareSnapshotService {
    @Override
    public ShareSnapshot create(ShareSnapshotCreate snapshotCreate) {
        Objects.requireNonNull(snapshotCreate);
        return this.post(ManilaShareSnapshot.class, this.uri("/snapshots", new Object[0])).entity(snapshotCreate).execute();
    }

    @Override
    public List<? extends ShareSnapshot> list() {
        return this.list(false);
    }

    @Override
    public List<? extends ShareSnapshot> listDetails() {
        return this.list(true);
    }

    private List<? extends ShareSnapshot> list(boolean detail) {
        return this.get(ManilaShareSnapshot.ShareSnapshots.class, this.uri("/snapshots" + (detail ? "/detail" : ""), new Object[0])).execute().getList();
    }

    @Override
    public ShareSnapshot get(String snapshotId) {
        Objects.requireNonNull(snapshotId);
        return this.get(ManilaShareSnapshot.class, this.uri("/snapshots/%s", snapshotId)).execute();
    }

    @Override
    public ShareSnapshot update(String snapshotId, ShareSnapshotUpdateOptions snapshotUpdateOptions) {
        Objects.requireNonNull(snapshotId);
        Objects.requireNonNull(snapshotUpdateOptions);
        return this.put(ManilaShareSnapshot.class, this.uri("/snapshots/%s", snapshotId)).entity(ManilaShareSnapshotUpdate.fromOptions(snapshotUpdateOptions)).execute();
    }

    @Override
    public ActionResponse delete(String snapshotId) {
        Objects.requireNonNull(snapshotId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/snapshots/%s", snapshotId)).executeWithResponse());
    }

    @Override
    public ActionResponse resetState(String snapshotId, ShareSnapshot.Status status) {
        Objects.requireNonNull(snapshotId);
        Objects.requireNonNull(status);
        return this.invokeAction(snapshotId, ShareSnapshotActions.resetState(status));
    }

    @Override
    public ActionResponse forceDelete(String snapshotId) {
        Objects.requireNonNull(snapshotId);
        return this.invokeAction(snapshotId, ShareSnapshotActions.forceDelete());
    }

    private ActionResponse invokeAction(String snapshotId, ShareSnapshotAction action) {
        return ToActionResponseFunction.INSTANCE.apply(this.post(Void.class, this.uri("/snapshots/%s/action", snapshotId)).entity(action).executeWithResponse());
    }
}

