/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.manila.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.manila.ShareNetworkService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.manila.ShareNetwork;
import org.openstack4j.model.manila.ShareNetworkCreate;
import org.openstack4j.model.manila.ShareNetworkUpdateOptions;
import org.openstack4j.model.manila.builder.ShareNetworkCreateBuilder;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.manila.domain.ManilaShareNetwork;
import org.openstack4j.openstack.manila.domain.ManilaShareNetworkCreate;
import org.openstack4j.openstack.manila.domain.ManilaShareNetworkUpdate;
import org.openstack4j.openstack.manila.domain.actions.SecurityServiceAction;
import org.openstack4j.openstack.manila.internal.BaseShareServices;

public class ShareNetworkServiceImpl
extends BaseShareServices
implements ShareNetworkService {
    @Override
    public ShareNetwork create(ShareNetworkCreate shareNetworkCreate) {
        Objects.requireNonNull(shareNetworkCreate);
        return this.post(ManilaShareNetwork.class, this.uri("/share-networks", new Object[0])).entity(shareNetworkCreate).execute();
    }

    @Override
    public List<? extends ShareNetwork> list() {
        return this.list(false);
    }

    @Override
    public List<? extends ShareNetwork> listDetails() {
        return this.list(true);
    }

    private List<? extends ShareNetwork> list(boolean detail) {
        return this.get(ManilaShareNetwork.ShareNetworks.class, this.uri("/share-networks" + (detail ? "/detail" : ""), new Object[0])).execute().getList();
    }

    @Override
    public ShareNetwork get(String shareNetworkId) {
        Objects.requireNonNull(shareNetworkId);
        return this.get(ManilaShareNetwork.class, this.uri("/share-networks/%s", shareNetworkId)).execute();
    }

    @Override
    public ShareNetwork update(String shareNetworkId, ShareNetworkUpdateOptions shareNetworkUpdateOptions) {
        Objects.requireNonNull(shareNetworkId);
        Objects.requireNonNull(shareNetworkUpdateOptions);
        return this.put(ManilaShareNetwork.class, this.uri("/share-networks/%s", shareNetworkId)).entity(ManilaShareNetworkUpdate.fromOptions(shareNetworkUpdateOptions)).execute();
    }

    @Override
    public ActionResponse delete(String shareNetworkId) {
        Objects.requireNonNull(shareNetworkId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/share-networks/%s", shareNetworkId)).executeWithResponse());
    }

    @Override
    public ShareNetwork addSecurityService(String shareNetworkId, String securityServiceId) {
        Objects.requireNonNull(shareNetworkId);
        Objects.requireNonNull(securityServiceId);
        return this.invokeSecurityServiceAction(shareNetworkId, SecurityServiceAction.add(securityServiceId));
    }

    @Override
    public ShareNetwork removeSecurityService(String shareNetworkId, String securityServiceId) {
        Objects.requireNonNull(shareNetworkId);
        Objects.requireNonNull(securityServiceId);
        return this.invokeSecurityServiceAction(shareNetworkId, SecurityServiceAction.remove(securityServiceId));
    }

    private ShareNetwork invokeSecurityServiceAction(String shareNetworkId, SecurityServiceAction action) {
        return this.post(ManilaShareNetwork.class, this.uri("/share-networks/%s/action", shareNetworkId)).entity(action).execute();
    }

    @Override
    public ShareNetworkCreateBuilder shareNetworkCreateBuilder() {
        return ManilaShareNetworkCreate.builder();
    }
}

