/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.manila.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.manila.SecurityServiceService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.manila.SecurityService;
import org.openstack4j.model.manila.SecurityServiceCreate;
import org.openstack4j.model.manila.SecurityServiceUpdateOptions;
import org.openstack4j.model.manila.builder.SecurityServiceCreateBuilder;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.manila.domain.ManilaSecurityService;
import org.openstack4j.openstack.manila.domain.ManilaSecurityServiceCreate;
import org.openstack4j.openstack.manila.domain.ManilaSecurityServiceUpdate;
import org.openstack4j.openstack.manila.internal.BaseShareServices;

public class SecurityServiceServiceImpl
extends BaseShareServices
implements SecurityServiceService {
    @Override
    public SecurityService create(SecurityServiceCreate securityServiceCreate) {
        Objects.requireNonNull(securityServiceCreate);
        return this.post(ManilaSecurityService.class, this.uri("/security-services", new Object[0])).entity(securityServiceCreate).execute();
    }

    @Override
    public List<? extends SecurityService> list() {
        return this.list(false);
    }

    @Override
    public List<? extends SecurityService> listDetails() {
        return this.list(true);
    }

    private List<? extends SecurityService> list(boolean detail) {
        return this.get(ManilaSecurityService.SecurityServices.class, this.uri("/security-services" + (detail ? "/detail" : ""), new Object[0])).execute().getList();
    }

    @Override
    public SecurityService get(String securityServiceId) {
        Objects.requireNonNull(securityServiceId);
        return this.get(ManilaSecurityService.class, this.uri("/security-services/%s", securityServiceId)).execute();
    }

    @Override
    public SecurityService update(String securityServiceId, SecurityServiceUpdateOptions securityServiceUpdateOptions) {
        Objects.requireNonNull(securityServiceId);
        Objects.requireNonNull(securityServiceUpdateOptions);
        return this.put(ManilaSecurityService.class, this.uri("/security-services/%s", securityServiceId)).entity(ManilaSecurityServiceUpdate.fromOptions(securityServiceUpdateOptions)).execute();
    }

    @Override
    public ActionResponse delete(String securityServiceId) {
        Objects.requireNonNull(securityServiceId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/security-services/%s", securityServiceId)).executeWithResponse());
    }

    @Override
    public SecurityServiceCreateBuilder securityServiceCreateBuilder() {
        return ManilaSecurityServiceCreate.builder();
    }
}

