/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.magnum;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.openstack4j.model.magnum.Container;
import org.openstack4j.model.magnum.ContainerBuilder;
import org.openstack4j.openstack.common.GenericLink;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.magnum.MagnumEnvironment;
import org.openstack4j.util.ToStringHelper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MagnumContainer
implements Container {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="links")
    private List<GenericLink> links;
    @JsonProperty(value="image")
    private String image;
    @JsonProperty(value="environment")
    private MagnumEnvironment environment;
    @JsonProperty(value="command")
    private String command;
    @JsonProperty(value="memory")
    private String memory;
    @JsonProperty(value="bay_uuid")
    private String bayUuid;
    @JsonProperty(value="name")
    private String name;

    public static ContainerBuilder builder() {
        return new ContainerConcreteBuilder();
    }

    @Override
    public ContainerBuilder toBuilder() {
        return new ContainerConcreteBuilder(this);
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public List<GenericLink> getLinks() {
        return this.links;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public MagnumEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public String getMemory() {
        return this.memory;
    }

    @Override
    public String getBayUuid() {
        return this.bayUuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return new ToStringHelper(this).add("status", this.status).add("uuid", this.uuid).add("links", this.links).add("image", this.image).add("environment", this.environment).add("command", this.command).add("memory", this.memory).add("bayUuid", this.bayUuid).add("name", this.name).toString();
    }

    public static class Containers
    extends ListResult<MagnumContainer> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="containers")
        private List<MagnumContainer> list;

        @Override
        public List<MagnumContainer> value() {
            return this.list;
        }
    }

    public static class ContainerConcreteBuilder
    implements ContainerBuilder {
        MagnumContainer model;

        public ContainerConcreteBuilder() {
            this(new MagnumContainer());
        }

        public ContainerConcreteBuilder(MagnumContainer model) {
            this.model = model;
        }

        @Override
        public Container build() {
            return this.model;
        }

        @Override
        public ContainerBuilder from(Container in) {
            if (in != null) {
                this.model = (MagnumContainer)in;
            }
            return this;
        }

        @Override
        public ContainerBuilder status(String status) {
            this.model.status = status;
            return this;
        }

        @Override
        public ContainerBuilder uuid(String uuid) {
            this.model.uuid = uuid;
            return this;
        }

        @Override
        public ContainerBuilder links(List<GenericLink> links) {
            this.model.links = links;
            return this;
        }

        @Override
        public ContainerBuilder image(String image) {
            this.model.image = image;
            return this;
        }

        @Override
        public ContainerBuilder environment(MagnumEnvironment environment) {
            this.model.environment = environment;
            return this;
        }

        @Override
        public ContainerBuilder command(String command) {
            this.model.command = command;
            return this;
        }

        @Override
        public ContainerBuilder memory(String memory) {
            this.model.memory = memory;
            return this;
        }

        @Override
        public ContainerBuilder bayUuid(String bayUuid) {
            this.model.bayUuid = bayUuid;
            return this;
        }

        @Override
        public ContainerBuilder name(String name) {
            this.model.name = name;
            return this;
        }
    }
}

