/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.magnum;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.openstack4j.model.magnum.Certificate;
import org.openstack4j.model.magnum.CertificateBuilder;
import org.openstack4j.openstack.common.GenericLink;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MagnumCertificate
implements Certificate {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="pem")
    private String pem;
    @JsonProperty(value="bay_uuid")
    private String bayUuid;
    @JsonProperty(value="links")
    private List<GenericLink> links;

    public static CertificateBuilder builder() {
        return new CertificateConcreteBuilder();
    }

    @Override
    public CertificateBuilder toBuilder() {
        return new CertificateConcreteBuilder(this);
    }

    @Override
    public String getPem() {
        return this.pem;
    }

    @Override
    public String getBayUuid() {
        return this.bayUuid;
    }

    @Override
    public List<GenericLink> getLinks() {
        return this.links;
    }

    public String toString() {
        return new ToStringHelper(this).add("pem", this.pem).add("bayUuid", this.bayUuid).add("links", this.links).toString();
    }

    public static class Certificates
    extends ListResult<MagnumCertificate> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="certificates")
        private List<MagnumCertificate> list;

        @Override
        public List<MagnumCertificate> value() {
            return this.list;
        }
    }

    public static class CertificateConcreteBuilder
    implements CertificateBuilder {
        MagnumCertificate model;

        public CertificateConcreteBuilder() {
            this(new MagnumCertificate());
        }

        public CertificateConcreteBuilder(MagnumCertificate model) {
            this.model = model;
        }

        @Override
        public Certificate build() {
            return this.model;
        }

        @Override
        public CertificateBuilder from(Certificate in) {
            if (in != null) {
                this.model = (MagnumCertificate)in;
            }
            return this;
        }

        @Override
        public CertificateBuilder pem(String pem) {
            this.model.pem = pem;
            return this;
        }

        @Override
        public CertificateBuilder bayUuid(String bayUuid) {
            this.model.bayUuid = bayUuid;
            return this;
        }

        @Override
        public CertificateBuilder links(List<GenericLink> links) {
            this.model.links = links;
            return this;
        }
    }
}

