/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.image.v2.domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstack4j.model.common.builder.BasicResourceBuilder;
import org.openstack4j.model.image.v2.ContainerFormat;
import org.openstack4j.model.image.v2.DiskFormat;
import org.openstack4j.model.image.v2.Image;
import org.openstack4j.model.image.v2.builder.ImageBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.common.Metadata;
import org.openstack4j.util.ToStringHelper;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GlanceImage
implements Image {
    private static final Set<String> RESERVED_KEYS = new HashSet<String>(Arrays.asList("id", "name", "tags", "status", "container_format", "disk_format", "created_at", "updated_at", "min_disk", "min_ram", "protected", "checksum", "owner", "visibility", "size", "locations", "direct_url", "self", "file", "schema", "architecture", "instance_uuid", "kernel_id", "os_version", "os_distro", "ramdisk_id", "virtual_size"));
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private List<String> tags;
    private Image.ImageStatus status;
    @JsonProperty(value="container_format")
    private ContainerFormat containerFormat;
    @JsonProperty(value="disk_format")
    private DiskFormat diskFormat;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    private Date updatedAt;
    @JsonProperty(value="min_disk")
    private Long minDisk;
    @JsonProperty(value="min_ram")
    private Long minRam;
    @JsonProperty(value="protected")
    private Boolean isProtected;
    private String checksum;
    private String owner;
    private Image.ImageVisibility visibility;
    private Long size;
    private List<Location> locations;
    @JsonProperty(value="direct_url")
    private String directUrl;
    private String self;
    private String file;
    private String schema;
    private String architecture;
    @JsonProperty(value="instance_uuid")
    private String instanceUuid;
    @JsonProperty(value="kernel_id")
    private String kernelId;
    @JsonProperty(value="os_version")
    private String osVersion;
    @JsonProperty(value="os_distro")
    private String osDistro;
    @JsonProperty(value="ramdisk_id")
    private String ramdiskId;
    @JsonProperty(value="virtual_size")
    private Long virtualSize;
    private Map<String, String> additionalProperties = new HashMap<String, String>();

    public static ImageBuilder builder() {
        return new ImageConcreteBuilder();
    }

    @Override
    public Image.ImageStatus getStatus() {
        return this.status;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public ContainerFormat getContainerFormat() {
        return this.containerFormat;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public DiskFormat getDiskFormat() {
        return this.diskFormat;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public Long getMinDisk() {
        return this.minDisk;
    }

    @Override
    public Boolean getIsProtected() {
        return this.isProtected;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Long getMinRam() {
        return this.minRam;
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public Image.ImageVisibility getVisibility() {
        return this.visibility;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    @Override
    public List<Location> getLocations() {
        return this.locations;
    }

    @Override
    public String getDirectUrl() {
        return this.directUrl;
    }

    @Override
    public String getSelf() {
        return this.self;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getRamdiskId() {
        return this.ramdiskId;
    }

    @Override
    public String getOsDistro() {
        return this.osDistro;
    }

    @Override
    public String getOsVersion() {
        return this.osVersion;
    }

    @Override
    public String getKernelId() {
        return this.kernelId;
    }

    @Override
    public String getInstanceUuid() {
        return this.instanceUuid;
    }

    @Override
    public String getArchitecture() {
        return this.architecture;
    }

    @Override
    public Long getVirtualSize() {
        return this.virtualSize;
    }

    @Override
    public String getAdditionalPropertyValue(String key) {
        return this.additionalProperties.get(key);
    }

    @JsonAnyGetter
    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String key, String value) {
        if (key != null && !RESERVED_KEYS.contains(key)) {
            this.additionalProperties.put(key, value);
        }
    }

    @Override
    public ImageBuilder toBuilder() {
        return new ImageConcreteBuilder(this);
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("name", this.name).add("tags", this.tags).add("imageStatus", (Object)this.status).add("containerFormat", (Object)this.containerFormat).add("diskFormat", (Object)this.diskFormat).add("createdAt", this.createdAt).add("updatedAt", this.updatedAt).add("minDisk", this.minDisk).add("minRam", this.minRam).add("isProtected", this.isProtected).add("checksum", this.checksum).add("owner", this.owner).add("visibility", (Object)this.visibility).add("size", this.size).add("locations", this.locations).add("directUrl", this.directUrl).add("self", this.self).add("file", this.file).add("schema", this.schema).add("architecture", this.architecture).add("instanceUuid", this.instanceUuid).add("kernelId", this.kernelId).add("osVersion", this.osVersion).add("osDistro", this.osDistro).add("ramdiskId", this.ramdiskId).add("virtualSize", this.virtualSize).toString();
    }

    public static class ImageConcreteBuilder
    extends BasicResourceBuilder<Image, ImageConcreteBuilder>
    implements ImageBuilder {
        private GlanceImage m;

        ImageConcreteBuilder() {
            this(new GlanceImage());
        }

        ImageConcreteBuilder(GlanceImage m) {
            this.m = m;
        }

        @Override
        public ImageBuilder visibility(Image.ImageVisibility visibility) {
            this.m.visibility = visibility;
            return this;
        }

        @Override
        public ImageBuilder tags(List<String> tags) {
            this.m.tags = tags;
            return this;
        }

        @Override
        public ImageBuilder containerFormat(ContainerFormat containerFormat) {
            this.m.containerFormat = containerFormat;
            return this;
        }

        @Override
        public ImageBuilder diskFormat(DiskFormat diskFormat) {
            this.m.diskFormat = diskFormat;
            return this;
        }

        @Override
        public ImageBuilder minDisk(Long minDisk) {
            this.m.minDisk = minDisk;
            return this;
        }

        @Override
        public ImageBuilder minRam(Long minRam) {
            this.m.minRam = minRam;
            return this;
        }

        @Override
        public ImageBuilder isProtected(Boolean isProtected) {
            this.m.isProtected = isProtected;
            return this;
        }

        @Override
        public ImageBuilder architecture(String architecture) {
            this.m.architecture = architecture;
            return this;
        }

        @Override
        public ImageBuilder instanceUuid(String instanceUuid) {
            this.m.instanceUuid = instanceUuid;
            return this;
        }

        @Override
        public ImageBuilder kernelId(String kernelId) {
            this.m.kernelId = kernelId;
            return this;
        }

        @Override
        public ImageBuilder osVersion(String osVersion) {
            this.m.osVersion = osVersion;
            return this;
        }

        @Override
        public ImageBuilder osDistro(String osDistro) {
            this.m.osDistro = osDistro;
            return this;
        }

        @Override
        public ImageBuilder ramdiskId(String ramdiskId) {
            this.m.ramdiskId = ramdiskId;
            return this;
        }

        @Override
        public ImageBuilder additionalProperty(String key, String value) {
            if (key != null && !RESERVED_KEYS.contains(key)) {
                this.m.additionalProperties.put(key, value);
            }
            return this;
        }

        @Override
        public Image build() {
            return this.m;
        }

        @Override
        public ImageBuilder from(Image in) {
            this.m = (GlanceImage)in;
            return this;
        }

        @Override
        protected Image reference() {
            return this.m;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Location {
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="metadata")
        private Metadata metadat;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Images
    extends ListResult<GlanceImage> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="images")
        private List<GlanceImage> images;

        @Override
        protected List<GlanceImage> value() {
            return this.images;
        }
    }
}

