/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openstack4j.api.identity.v3.UserService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Domain;
import org.openstack4j.model.identity.v3.Group;
import org.openstack4j.model.identity.v3.Project;
import org.openstack4j.model.identity.v3.Role;
import org.openstack4j.model.identity.v3.User;
import org.openstack4j.openstack.common.MapEntity;
import org.openstack4j.openstack.identity.v3.domain.KeystoneDomain;
import org.openstack4j.openstack.identity.v3.domain.KeystoneGroup;
import org.openstack4j.openstack.identity.v3.domain.KeystoneProject;
import org.openstack4j.openstack.identity.v3.domain.KeystoneRole;
import org.openstack4j.openstack.identity.v3.domain.KeystoneUser;
import org.openstack4j.openstack.identity.v3.internal.BaseIdentityServices;

public class UserServiceImpl
extends BaseIdentityServices
implements UserService {
    @Override
    public User get(String userId) {
        Objects.requireNonNull(userId);
        return this.get(KeystoneUser.class, "/users", "/", userId).execute();
    }

    @Override
    public List<? extends User> getByName(String userName) {
        Objects.requireNonNull(userName);
        return this.get(KeystoneUser.Users.class, this.uri("/users", new Object[0])).param("name", userName).execute().getList();
    }

    @Override
    public User getByName(String userName, String domainId) {
        Objects.requireNonNull(userName);
        Objects.requireNonNull(domainId);
        return (User)this.get(KeystoneUser.Users.class, this.uri("/users", new Object[0])).param("name", userName).param("domain_id", domainId).execute().first();
    }

    @Override
    public Domain getUserDomain(String userId) {
        return this.get(KeystoneDomain.class, "/domains", "/", this.get(userId).getDomainId()).execute();
    }

    @Override
    public ActionResponse delete(String userId) {
        Objects.requireNonNull(userId);
        return this.deleteWithResponse("/users", "/", userId).execute();
    }

    @Override
    public User update(User user) {
        Objects.requireNonNull(user);
        return this.patch(KeystoneUser.class, "/users", "/", user.getId()).entity(user).execute();
    }

    @Override
    public User create(User user) {
        Objects.requireNonNull(user);
        return this.post(KeystoneUser.class, this.uri("/users", new Object[0])).entity(user).execute();
    }

    @Override
    public User create(String domainId, String name, String password, String email, boolean enabled) {
        Objects.requireNonNull(domainId);
        Objects.requireNonNull(name);
        Objects.requireNonNull(password);
        Objects.requireNonNull(email);
        Objects.requireNonNull(enabled);
        return this.create((User)KeystoneUser.builder().domainId(domainId).name(name).password(password).email(email).enabled(enabled).build());
    }

    @Override
    public List<? extends Group> listUserGroups(String userId) {
        Objects.requireNonNull(userId);
        return this.get(KeystoneGroup.Groups.class, this.uri("/users/%s/groups", userId)).execute().getList();
    }

    @Override
    public List<? extends Project> listUserProjects(String userId) {
        Objects.requireNonNull(userId);
        return this.get(KeystoneProject.Projects.class, this.uri("/users/%s/projects", userId)).execute().getList();
    }

    @Override
    public List<? extends User> list() {
        return this.get(KeystoneUser.Users.class, this.uri("/users", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Role> listProjectUserRoles(String userId, String projectId) {
        Objects.requireNonNull(userId);
        Objects.requireNonNull(projectId);
        return this.get(KeystoneRole.Roles.class, this.uri("projects/%s/users/%s/roles", projectId, userId)).execute().getList();
    }

    @Override
    public List<? extends Role> listDomainUserRoles(String userId, String domainId) {
        Objects.requireNonNull(userId);
        Objects.requireNonNull(domainId);
        return this.get(KeystoneRole.Roles.class, this.uri("domains/%s/users/%s/roles", domainId, userId)).execute().getList();
    }

    @Override
    public ActionResponse changePassword(String userId, String originalPassword, String password) {
        Objects.requireNonNull(userId);
        Objects.requireNonNull(originalPassword);
        Objects.requireNonNull(password);
        HashMap<String, String> passwordMap = new HashMap<String, String>();
        passwordMap.put("original_password", originalPassword);
        passwordMap.put("password", password);
        MapEntity mapEntity = MapEntity.create("user", passwordMap);
        return this.post(ActionResponse.class, this.uri("/users/%s/password", userId)).entity(mapEntity).execute();
    }
}

