/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.identity.v3.RegionService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Region;
import org.openstack4j.openstack.identity.v3.domain.KeystoneRegion;
import org.openstack4j.openstack.identity.v3.internal.BaseIdentityServices;

public class RegionServiceImpl
extends BaseIdentityServices
implements RegionService {
    @Override
    public Region create(Region region) {
        Objects.requireNonNull(region);
        return this.post(KeystoneRegion.class, this.uri("/regions", new Object[0])).entity(region).execute();
    }

    @Override
    public Region create(String regionId, String description, String parentRegionId) {
        Objects.requireNonNull(regionId);
        Objects.requireNonNull(description);
        Objects.requireNonNull(parentRegionId);
        return this.create((Region)KeystoneRegion.builder().id(regionId).description(description).parentRegionId(parentRegionId).build());
    }

    @Override
    public Region get(String regionId) {
        Objects.requireNonNull(regionId);
        return this.get(KeystoneRegion.class, "/regions", "/", regionId).execute();
    }

    @Override
    public Region update(Region region) {
        Objects.requireNonNull(region);
        return this.patch(KeystoneRegion.class, "/regions", "/", region.getId()).entity(region).execute();
    }

    @Override
    public ActionResponse delete(String regionId) {
        Objects.requireNonNull(regionId);
        return this.deleteWithResponse("/regions", "/", regionId).execute();
    }

    @Override
    public List<? extends Region> list() {
        return this.get(KeystoneRegion.Regions.class, this.uri("/regions", new Object[0])).execute().getList();
    }
}

