/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.identity.v3.DomainService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Domain;
import org.openstack4j.openstack.identity.v3.domain.KeystoneDomain;
import org.openstack4j.openstack.identity.v3.internal.BaseIdentityServices;

public class DomainServiceImpl
extends BaseIdentityServices
implements DomainService {
    @Override
    public Domain create(Domain domain) {
        Objects.requireNonNull(domain);
        return this.post(KeystoneDomain.class, "/domains").entity(domain).execute();
    }

    @Override
    public Domain create(String name, String description, boolean enabled) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(description);
        Objects.requireNonNull(enabled);
        return this.create((Domain)KeystoneDomain.builder().name(name).description(description).enabled(enabled).build());
    }

    @Override
    public Domain update(Domain domain) {
        Objects.requireNonNull(domain);
        return this.patch(KeystoneDomain.class, "/domains", "/", domain.getId()).entity(domain).execute();
    }

    @Override
    public Domain get(String domainId) {
        Objects.requireNonNull(domainId);
        return this.get(KeystoneDomain.class, "/domains", "/", domainId).execute();
    }

    @Override
    public List<? extends Domain> getByName(String domainName) {
        Objects.requireNonNull(domainName);
        return this.get(KeystoneDomain.Domains.class, this.uri("/domains", new Object[0])).param("name", domainName).execute().getList();
    }

    @Override
    public ActionResponse delete(String domainId) {
        Objects.requireNonNull(domainId);
        return this.deleteWithResponse("/domains", "/", domainId).execute();
    }

    @Override
    public List<? extends Domain> list() {
        return this.get(KeystoneDomain.Domains.class, this.uri("/domains", new Object[0])).execute().getList();
    }
}

