/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Date;
import java.util.List;
import org.openstack4j.model.identity.AuthStore;
import org.openstack4j.model.identity.AuthVersion;
import org.openstack4j.model.identity.v3.Service;
import org.openstack4j.model.identity.v3.Token;
import org.openstack4j.openstack.identity.functions.ServiceFunctions;
import org.openstack4j.openstack.identity.v3.domain.KeystoneAuth;
import org.openstack4j.openstack.identity.v3.domain.KeystoneDomain;
import org.openstack4j.openstack.identity.v3.domain.KeystoneProject;
import org.openstack4j.openstack.identity.v3.domain.KeystoneRole;
import org.openstack4j.openstack.identity.v3.domain.KeystoneService;
import org.openstack4j.openstack.identity.v3.domain.KeystoneUser;
import org.openstack4j.openstack.identity.v3.domain.TokenAuth;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="token")
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeystoneToken
implements Token {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private String id;
    @JsonProperty(value="expires_at")
    private Date expires;
    @JsonProperty(value="issued_at")
    private Date issued;
    @JsonProperty(value="audit_ids")
    private List<String> auditIds;
    @JsonProperty
    private List<String> methods;
    @JsonProperty
    private List<KeystoneRole> roles;
    @JsonProperty(required=false)
    private KeystoneProject project;
    @JsonProperty(required=false)
    private KeystoneDomain domain;
    @JsonProperty
    private KeystoneUser user;
    @JsonProperty
    private List<KeystoneService> catalog;
    private KeystoneAuth credentials;
    private String endpoint;
    @JsonIgnore
    private String extras;
    @JsonIgnore
    private volatile SortedSetMultimap<String, Service> aggregatedCatalog;

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("expires", this.expires).add("issued", this.issued).add("auditIds", this.auditIds).add("methods", this.methods).add("user", this.user).add("roles", this.roles).add("project", this.project).add("domain", this.domain).addValue("\n").add("catalog", this.catalog).toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Date getExpires() {
        return this.expires;
    }

    @Override
    public AuthVersion getVersion() {
        return AuthVersion.V3;
    }

    @Override
    public Date getIssuedAt() {
        return this.issued;
    }

    @Override
    public List<String> getAuditIds() {
        return this.auditIds;
    }

    @Override
    public List<String> getMethods() {
        return this.methods;
    }

    public List<? extends KeystoneService> getCatalog() {
        return this.catalog;
    }

    @Override
    public KeystoneProject getProject() {
        return this.project;
    }

    @Override
    public KeystoneDomain getDomain() {
        return this.domain;
    }

    @Override
    public KeystoneUser getUser() {
        return this.user;
    }

    public List<? extends KeystoneRole> getRoles() {
        return this.roles;
    }

    @Override
    public KeystoneAuth getCredentials() {
        return this.credentials;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public KeystoneToken applyContext(String endpoint, KeystoneAuth credentials) {
        this.credentials = credentials;
        this.endpoint = endpoint;
        return this;
    }

    public KeystoneToken applyContext(String endpoint, TokenAuth token) {
        this.endpoint = endpoint;
        return this;
    }

    public KeystoneToken applyContext(String endpoint, AuthStore credentials) {
        this.endpoint = endpoint;
        this.credentials = new KeystoneAuth(endpoint, credentials.getPassword());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JsonIgnore
    public SortedSetMultimap<String, Service> getAggregatedCatalog() {
        if (this.aggregatedCatalog == null) {
            KeystoneToken keystoneToken = this;
            synchronized (keystoneToken) {
                if (this.aggregatedCatalog == null) {
                    this.aggregatedCatalog = TreeMultimap.create();
                    for (Service service : this.catalog) {
                        String nameKey = ServiceFunctions.TYPE_WITHOUT_VERSION.apply(service.getName());
                        String typeKey = ServiceFunctions.TYPE_WITHOUT_VERSION.apply(service.getType());
                        this.aggregatedCatalog.put((Object)nameKey, (Object)service);
                        this.aggregatedCatalog.put((Object)typeKey, (Object)service);
                    }
                }
            }
        }
        return this.aggregatedCatalog;
    }

    @Override
    @JsonIgnore
    public String getCacheIdentifier() {
        String uniq = null;
        uniq = this.getProject() != null ? this.getProject().getId() : (this.getDomain() != null ? this.getDomain().getId() : (this.user != null ? this.user.getId() : ""));
        return String.format("%s:%s", this.endpoint, uniq);
    }
}

