/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.identity.v3.RoleAssignment;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KeystoneRoleAssignment
implements RoleAssignment {
    private static final long serialVersionUID = 1L;
    private String roleId;
    private String userId;
    private String groupId;
    private String domainId;
    private String projectId;
    private Map<String, String> links;

    @Override
    public String getRoleId() {
        return this.roleId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getDomainId() {
        return this.domainId;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @JsonProperty(value="user")
    public void setUser(Map<String, Object> user) {
        this.userId = (String)user.get("id");
    }

    @JsonProperty(value="role")
    public void setRole(Map<String, Object> role) {
        this.roleId = (String)role.get("id");
    }

    @JsonProperty(value="group")
    public void setGroup(Map<String, Object> group) {
        this.groupId = (String)group.get("id");
    }

    @JsonProperty(value="scope")
    public void setScope(Map<String, Object> group) {
        Map domainScope;
        Map projectScope = (Map)group.get("project");
        if (projectScope != null) {
            this.projectId = (String)projectScope.get("id");
        }
        if ((domainScope = (Map)group.get("domain")) != null) {
            this.domainId = (String)domainScope.get("id");
        }
    }

    @Override
    public Map<String, String> getLinks() {
        return this.links;
    }

    public String toString() {
        return new ToStringHelper(this).add("roleId", this.roleId).add("groupId", this.groupId).add("userId", this.userId).add("projectId", this.projectId).add("domainId", this.domainId).add("links", this.links).toString();
    }

    public static class RoleAssignments
    extends ListResult<KeystoneRoleAssignment> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="role_assignments")
        protected List<KeystoneRoleAssignment> list;

        @Override
        public List<KeystoneRoleAssignment> value() {
            return this.list;
        }
    }
}

