/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.heat.utils;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.openstack4j.openstack.heat.utils.Template;
import org.openstack4j.openstack.heat.utils.TemplateUtils;
import org.yaml.snakeyaml.Yaml;

public class Environment {
    private String envContent;
    private Map<String, String> files = new HashMap<String, String>();
    private URL baseUrl;

    public Environment(URL environmentRes) throws JsonParseException, IOException, URISyntaxException {
        this.setEnvContent(TemplateUtils.readToString(environmentRes));
        this.setBaseUrl(TemplateUtils.baseUrl(environmentRes.toString()));
        this.getFileContent();
    }

    public Environment(String environmentLoc) throws JsonParseException, MalformedURLException, UnsupportedEncodingException, IOException, URISyntaxException {
        this(TemplateUtils.normaliseFilePathToUrl(environmentLoc));
    }

    private Map<String, String> getResourceRegistry() {
        Yaml yaml = new Yaml();
        Map content = (Map)yaml.load(this.getEnvContent());
        return (Map)content.get("resource_registry");
    }

    private void getFileContent() throws JsonParseException, MalformedURLException, UnsupportedEncodingException, IOException, URISyntaxException {
        Map<String, String> rr = this.getResourceRegistry();
        if (rr == null) {
            return;
        }
        if (rr.get("base_url") != null) {
            this.setBaseUrl(new URL(rr.get("base_url")));
        }
        for (String resourceType : rr.keySet()) {
            if (resourceType.equals("base_url") || "OS::Heat::None".equals(rr.get(resourceType))) continue;
            URL tplUrl = new URL(this.baseUrl, rr.get(resourceType));
            Template tpl = new Template(tplUrl);
            this.files.put(rr.get(resourceType), tpl.getTplContent());
            Map<String, String> fileFromTemplate = tpl.getFiles();
            for (String file : fileFromTemplate.keySet()) {
                if (this.files.containsKey(file)) continue;
                this.files.put(file, fileFromTemplate.get(file));
            }
        }
    }

    public String getEnvContent() {
        return this.envContent;
    }

    public void setEnvContent(String envContent) {
        this.envContent = envContent;
    }

    public Map<String, String> getFiles() {
        return this.files;
    }

    public void setFiles(Map<String, String> files) {
        this.files = files;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }
}

