/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.heat.internal;

import java.util.Objects;
import org.openstack4j.api.heat.SoftwareConfigService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.heat.SoftwareConfig;
import org.openstack4j.openstack.heat.domain.HeatSoftwareConfig;
import org.openstack4j.openstack.heat.internal.BaseHeatServices;

public class SoftwareConfigServiceImpl
extends BaseHeatServices
implements SoftwareConfigService {
    private static final String BASE_URI = "/software_configs";

    @Override
    public SoftwareConfig create(SoftwareConfig sc) {
        Objects.requireNonNull(sc);
        return this.post(HeatSoftwareConfig.class, BASE_URI).entity(sc).execute();
    }

    @Override
    public SoftwareConfig show(String configId) {
        Objects.requireNonNull(configId);
        return this.get(HeatSoftwareConfig.class, this.uri("/software_configs/%s", configId)).execute();
    }

    @Override
    public ActionResponse delete(String configId) {
        Objects.requireNonNull(configId);
        return this.deleteWithResponse(this.uri("/software_configs/%s", configId)).execute();
    }
}

