/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.heat.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.heat.AdoptStackData;

public class HeatStackAdopt
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="stack_name")
    private String name;
    @JsonProperty(value="timeout_mins")
    private Long timeoutMins;
    @JsonProperty(value="parameters")
    private Map<String, String> parameters;
    @JsonProperty(value="disable_rollback")
    private boolean disableRollback;
    @JsonProperty(value="adopt_stack_data")
    private String adoptStackData;
    @JsonProperty(value="template")
    private String template;

    public static HeatStackAdoptBuilder builder() {
        return new HeatStackAdoptBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Long getTimeoutMins() {
        return this.timeoutMins;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isDisableRollback() {
        return this.disableRollback;
    }

    public String getAdoptStackData() {
        return this.adoptStackData;
    }

    public String getTemplate() {
        return this.template;
    }

    public static class HeatStackAdoptBuilder {
        private HeatStackAdopt model;

        public HeatStackAdoptBuilder(HeatStackAdopt model) {
            this.model = model;
        }

        public HeatStackAdoptBuilder() {
            this.model = new HeatStackAdopt();
        }

        public HeatStackAdoptBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        public HeatStackAdoptBuilder timeoutMins(Long timeoutMins) {
            this.model.timeoutMins = timeoutMins;
            return this;
        }

        public HeatStackAdoptBuilder parameters(Map<String, String> parameters) {
            this.model.parameters = parameters;
            return this;
        }

        public HeatStackAdoptBuilder disableRollback(boolean disableRollback) {
            this.model.disableRollback = disableRollback;
            return this;
        }

        public HeatStackAdoptBuilder adoptStackData(AdoptStackData adoptStackData) {
            try {
                this.model.adoptStackData = new ObjectMapper().writeValueAsString((Object)adoptStackData);
                return this;
            }
            catch (JsonProcessingException ex) {
                Logger.getLogger(HeatStackAdopt.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }

        public HeatStackAdoptBuilder template(String template) {
            this.model.template = template;
            return this;
        }

        public HeatStackAdopt build() {
            return this.model;
        }
    }
}

