/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.gbp.PolicyActionService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.gbp.PolicyAction;
import org.openstack4j.model.gbp.PolicyActionUpdate;
import org.openstack4j.openstack.gbp.domain.GbpPolicyAction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class PolicyActionServiceImpl
extends BaseNetworkingServices
implements PolicyActionService {
    @Override
    public List<? extends PolicyAction> list() {
        return this.get(GbpPolicyAction.PolicyActions.class, this.uri("/grouppolicy/policy_actions", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends PolicyAction> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpPolicyAction.PolicyActions> policyactionInvocation = this.buildInvocation(filteringParams);
        return policyactionInvocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<GbpPolicyAction.PolicyActions> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpPolicyAction.PolicyActions> policyactionInvocation = this.get(GbpPolicyAction.PolicyActions.class, "/grouppolicy/policy_actions");
        if (filteringParams == null) {
            return policyactionInvocation;
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                policyactionInvocation = policyactionInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return policyactionInvocation;
    }

    @Override
    public PolicyAction get(String id) {
        Objects.requireNonNull(id);
        return this.get(GbpPolicyAction.class, this.uri("/grouppolicy/policy_actions/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Objects.requireNonNull(id);
        return this.deleteWithResponse(this.uri("/grouppolicy/policy_actions/%s", id)).execute();
    }

    @Override
    public PolicyAction create(PolicyAction policyAction) {
        return this.post(GbpPolicyAction.class, this.uri("/grouppolicy/policy_actions", new Object[0])).entity(policyAction).execute();
    }

    @Override
    public PolicyAction update(String policyActionId, PolicyActionUpdate policyAction) {
        Objects.requireNonNull(policyActionId);
        Objects.requireNonNull(policyAction);
        return this.put(GbpPolicyAction.class, this.uri("/grouppolicy/policy_actions/%s", policyActionId)).entity(policyAction).execute();
    }
}

