/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.gbp.L2policyService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.gbp.L2Policy;
import org.openstack4j.openstack.gbp.domain.GbpL2Policy;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class L2policyServiceImpl
extends BaseNetworkingServices
implements L2policyService {
    @Override
    public List<? extends L2Policy> list() {
        return this.get(GbpL2Policy.L2Policies.class, this.uri("/grouppolicy/l2_policies", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends L2Policy> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpL2Policy.L2Policies> l2PoliciesInvocation = this.buildInvocation(filteringParams);
        return l2PoliciesInvocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<GbpL2Policy.L2Policies> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpL2Policy.L2Policies> l2PoliciesInvocation = this.get(GbpL2Policy.L2Policies.class, "/grouppolicy/l2_policies");
        if (filteringParams == null) {
            return l2PoliciesInvocation;
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                l2PoliciesInvocation = l2PoliciesInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return l2PoliciesInvocation;
    }

    @Override
    public L2Policy get(String id) {
        Objects.requireNonNull(id);
        return this.get(GbpL2Policy.class, this.uri("/grouppolicy/l2_policies/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Objects.requireNonNull(id);
        return this.deleteWithResponse(this.uri("/grouppolicy/l2_policies/%s", id)).execute();
    }

    @Override
    public L2Policy create(L2Policy l2Policy) {
        return this.post(GbpL2Policy.class, this.uri("/grouppolicy/l2_policies", new Object[0])).entity(l2Policy).execute();
    }

    @Override
    public L2Policy update(String l2PolicyId, L2Policy l2Policy) {
        Objects.requireNonNull(l2PolicyId);
        Objects.requireNonNull(l2Policy);
        return this.put(GbpL2Policy.class, this.uri("/grouppolicy/l2_policies/%s", l2PolicyId)).entity(l2Policy).execute();
    }
}

