/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import org.openstack4j.model.gbp.PolicyRuleSet;
import org.openstack4j.model.gbp.builder.PolicyRuleSetBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="policy_rule_set")
public class GbpPolicyRuleSet
implements PolicyRuleSet {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String id;
    private String description;
    private boolean shared;
    @JsonProperty(value="parent_id")
    private String parentId;
    @JsonProperty(value="child_policy_rule_sets")
    private List<String> childPolicyRuleSets;
    @JsonProperty(value="policy_rules")
    private List<String> policyRules;

    public static PolicyRuleSetBuilder builder() {
        return new PolicyRuleSetConcreteBuilder();
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public List<String> getChildPolicyRuleSets() {
        return this.childPolicyRuleSets;
    }

    @Override
    public List<String> getPolicyRules() {
        return this.policyRules;
    }

    @Override
    public PolicyRuleSetBuilder toBuilder() {
        return new PolicyRuleSetConcreteBuilder(this);
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("name", this.name).add("desription", this.description).add("tenantId", this.tenantId).add("parentId", this.parentId).add("childPolicyRuleSets", this.childPolicyRuleSets).add("shared", this.shared).add("policyRules", this.policyRules).toString();
    }

    public static class PolicyRuleSetConcreteBuilder
    implements PolicyRuleSetBuilder {
        private GbpPolicyRuleSet policyRuleSet;

        public PolicyRuleSetConcreteBuilder(GbpPolicyRuleSet gbpPolicyRuleSet) {
            this.policyRuleSet = gbpPolicyRuleSet;
        }

        public PolicyRuleSetConcreteBuilder() {
            this(new GbpPolicyRuleSet());
        }

        @Override
        public PolicyRuleSet build() {
            return this.policyRuleSet;
        }

        @Override
        public PolicyRuleSetBuilder from(PolicyRuleSet in) {
            this.policyRuleSet = (GbpPolicyRuleSet)in;
            return this;
        }

        @Override
        public PolicyRuleSetBuilder name(String name) {
            this.policyRuleSet.name = name;
            return this;
        }

        @Override
        public PolicyRuleSetBuilder description(String description) {
            this.policyRuleSet.description = description;
            return this;
        }

        @Override
        public PolicyRuleSetBuilder shared(boolean shared) {
            this.policyRuleSet.shared = shared;
            return this;
        }

        @Override
        public PolicyRuleSetBuilder rules(List<String> ruleIds) {
            this.policyRuleSet.policyRules = ruleIds;
            return this;
        }
    }

    public static class PolicyRuleSets
    extends ListResult<GbpPolicyRuleSet> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="policy_rule_sets")
        private List<GbpPolicyRuleSet> policyRuleSets;

        @Override
        protected List<GbpPolicyRuleSet> value() {
            return this.policyRuleSets;
        }
    }
}

