/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.gbp.L3Policy;
import org.openstack4j.model.gbp.builder.L3PolicyBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="l3_policy")
public class GbpL3Policy
implements L3Policy {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String id;
    private String description;
    @JsonProperty(value="external_segments")
    private Map<String, List<String>> externalSegments;
    @JsonProperty(value="ip_pool")
    private String ipPool;
    @JsonProperty(value="ip_version")
    private int ipVersion;
    @JsonProperty(value="l2_policies")
    private List<String> l2Policies;
    private List<String> routers;
    private Boolean shared;
    @JsonProperty(value="subnet_prefix_length")
    private String subnetPrefixLength;

    public static L3PolicyBuilder builder() {
        return new L3PolicyConcreteBuilder();
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, List<String>> getExternalSegments() {
        return this.externalSegments;
    }

    @Override
    public String getIpPool() {
        return this.ipPool;
    }

    @Override
    public int getIpVersion() {
        return this.ipVersion;
    }

    @Override
    public List<String> getL2Policies() {
        return this.l2Policies;
    }

    @Override
    public List<String> getRouters() {
        return this.routers;
    }

    @Override
    public boolean isShared() {
        return this.shared == null ? false : this.shared;
    }

    @Override
    public String getSubnetPrefixLength() {
        return this.subnetPrefixLength;
    }

    @Override
    public L3PolicyBuilder toBuilder() {
        return new L3PolicyConcreteBuilder(this);
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("name", this.name).add("desription", this.description).add("tenantId", this.tenantId).add("externalSegments", this.externalSegments).add("ipPool", this.ipPool).add("ipVersion", this.ipVersion).add("l2Policies", this.l2Policies).add("routers", this.routers).add("shared", this.shared).add("subnetPrefixLength", this.subnetPrefixLength).toString();
    }

    public static class L3PolicyConcreteBuilder
    implements L3PolicyBuilder {
        private GbpL3Policy l3Policy;

        public L3PolicyConcreteBuilder(GbpL3Policy gbpL3Policy) {
            this.l3Policy = gbpL3Policy;
        }

        public L3PolicyConcreteBuilder() {
            this(new GbpL3Policy());
        }

        @Override
        public L3Policy build() {
            return this.l3Policy;
        }

        @Override
        public L3PolicyBuilder from(L3Policy in) {
            this.l3Policy = (GbpL3Policy)in;
            return this;
        }

        @Override
        public L3PolicyBuilder name(String name) {
            this.l3Policy.name = name;
            return this;
        }

        @Override
        public L3PolicyBuilder description(String description) {
            this.l3Policy.description = description;
            return this;
        }

        @Override
        public L3PolicyBuilder ipVersion(int ipVersion) {
            this.l3Policy.ipVersion = ipVersion;
            return this;
        }

        @Override
        public L3PolicyBuilder ippool(String ippool) {
            this.l3Policy.ipPool = ippool;
            return this;
        }

        @Override
        public L3PolicyBuilder subnetPrefixLength(String subnetPrefixLength) {
            this.l3Policy.subnetPrefixLength = subnetPrefixLength;
            return this;
        }

        @Override
        public L3PolicyBuilder isShared(boolean shared) {
            this.l3Policy.shared = shared;
            return this;
        }

        @Override
        public L3PolicyBuilder externalSegments(List<String> extSegmentIds) {
            this.l3Policy.externalSegments = new HashMap();
            for (String extSegId : extSegmentIds) {
                this.l3Policy.externalSegments.put(extSegId, new ArrayList());
            }
            return this;
        }
    }

    public static class L3Policies
    extends ListResult<GbpL3Policy> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="l3_policies")
        private List<GbpL3Policy> l3Policies;

        @Override
        protected List<GbpL3Policy> value() {
            return this.l3Policies;
        }
    }
}

