/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import org.openstack4j.model.gbp.L2Policy;
import org.openstack4j.model.gbp.builder.L2PolicyBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="l2_policy")
public class GbpL2Policy
implements L2Policy {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String id;
    private String description;
    @JsonProperty(value="network_id")
    private String networkId;
    @JsonProperty(value="l3_policy_id")
    private String l3PolicyId;
    private Boolean shared;
    @JsonProperty(value="policy_target_groups")
    private List<String> policyTargetGroups;

    public static L2PolicyBuilder builder() {
        return new L2PolicyConcreteBuilder();
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public L2PolicyBuilder toBuilder() {
        return new L2PolicyConcreteBuilder(this);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getNetworkId() {
        return this.networkId;
    }

    @Override
    public String getL3PolicyId() {
        return this.l3PolicyId;
    }

    @Override
    public boolean isShared() {
        return this.shared == null ? false : this.shared;
    }

    @Override
    public List<String> getPolicyTargetGroups() {
        return this.policyTargetGroups;
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("name", this.name).add("desription", this.description).add("tenantId", this.tenantId).add("networkId", this.networkId).add("l3PolicyId", this.l3PolicyId).add("shared", this.shared).add("policyTargetGroups", this.policyTargetGroups).toString();
    }

    public static class L2PolicyConcreteBuilder
    implements L2PolicyBuilder {
        private GbpL2Policy l2Policy;

        public L2PolicyConcreteBuilder(GbpL2Policy gbpL2Policy) {
            this.l2Policy = gbpL2Policy;
        }

        public L2PolicyConcreteBuilder() {
            this(new GbpL2Policy());
        }

        @Override
        public L2Policy build() {
            return this.l2Policy;
        }

        @Override
        public L2PolicyBuilder from(L2Policy in) {
            this.l2Policy = (GbpL2Policy)in;
            return this;
        }

        @Override
        public L2PolicyBuilder name(String name) {
            this.l2Policy.name = name;
            return this;
        }

        @Override
        public L2PolicyBuilder description(String description) {
            this.l2Policy.description = description;
            return this;
        }

        @Override
        public L2PolicyBuilder isShared(boolean shared) {
            this.l2Policy.shared = shared;
            return this;
        }

        @Override
        public L2PolicyBuilder networkId(String id) {
            this.l2Policy.id = id;
            return this;
        }

        @Override
        public L2PolicyBuilder l3PolicyId(String id) {
            this.l2Policy.l3PolicyId = id;
            return this;
        }

        @Override
        public L2PolicyBuilder policyTargetGroups(List<String> ids) {
            this.l2Policy.policyTargetGroups = ids;
            return this;
        }
    }

    public static class L2Policies
    extends ListResult<GbpL2Policy> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="l2_policies")
        private List<GbpL2Policy> l2Policies;

        @Override
        protected List<GbpL2Policy> value() {
            return this.l2Policies;
        }
    }
}

