/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.dns.v2.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.dns.v2.ZoneService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.dns.v2.Nameserver;
import org.openstack4j.model.dns.v2.Zone;
import org.openstack4j.openstack.dns.v2.domain.DesignateNameserver;
import org.openstack4j.openstack.dns.v2.domain.DesignateZone;
import org.openstack4j.openstack.dns.v2.internal.BaseDNSServices;

public class ZoneServiceImpl
extends BaseDNSServices
implements ZoneService {
    @Override
    public Zone get(String zoneId) {
        Objects.requireNonNull(zoneId);
        return this.get(DesignateZone.class, "/zones", "/", zoneId).execute();
    }

    @Override
    public ActionResponse delete(String zoneId) {
        Objects.requireNonNull(zoneId);
        return this.deleteWithResponse("/zones", "/", zoneId).execute();
    }

    @Override
    public List<? extends Nameserver> listNameservers(String zoneId) {
        Objects.requireNonNull(zoneId);
        return this.get(DesignateNameserver.Nameservers.class, "/zones", "/", zoneId, "/nameservers").execute().getList();
    }

    @Override
    public Zone update(Zone zone) {
        Objects.requireNonNull(zone);
        return this.patch(DesignateZone.class, "/zones", "/", zone.getId()).entity(zone).execute();
    }

    @Override
    public Zone create(Zone zone) {
        Objects.requireNonNull(zone);
        return this.post(DesignateZone.class, this.uri("/zones", new Object[0])).entity(zone).execute();
    }

    @Override
    public Zone create(String name, String email) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(email);
        return this.create((Zone)DesignateZone.builder().name(name).email(email).build());
    }

    @Override
    public List<? extends Zone> list() {
        return this.get(DesignateZone.Zones.class, this.uri("/zones", new Object[0])).execute().getList();
    }
}

