/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.dns.v2.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.dns.v2.RecordsetService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.dns.v2.Recordset;
import org.openstack4j.openstack.dns.v2.domain.DesignateRecordset;
import org.openstack4j.openstack.dns.v2.internal.BaseDNSServices;

public class RecordsetServiceImpl
extends BaseDNSServices
implements RecordsetService {
    @Override
    public Recordset get(String zoneId, String recordsetId) {
        Objects.requireNonNull(zoneId);
        Objects.requireNonNull(recordsetId);
        return this.get(DesignateRecordset.class, "/zones", "/", zoneId, "/recordsets", "/", recordsetId).execute();
    }

    @Override
    public ActionResponse delete(String zoneId, String recordsetId) {
        Objects.requireNonNull(zoneId);
        Objects.requireNonNull(recordsetId);
        return this.deleteWithResponse("/zones", "/", zoneId, "/recordsets", "/", recordsetId).execute();
    }

    @Override
    public Recordset update(String zoneId, Recordset recordset) {
        Objects.requireNonNull(zoneId);
        Objects.requireNonNull(recordset);
        return this.put(DesignateRecordset.class, "/zones", "/", zoneId, "/recordsets", "/", recordset.getId()).entity(recordset).execute();
    }

    @Override
    public Recordset create(String zoneId, Recordset recordset) {
        Objects.requireNonNull(zoneId);
        Objects.requireNonNull(recordset);
        return this.post(DesignateRecordset.class, "/zones", "/", zoneId, "/recordsets").entity(recordset).execute();
    }

    @Override
    public Recordset create(String zoneId, String name, String type, List<String> records) {
        Objects.requireNonNull(zoneId);
        Objects.requireNonNull(name);
        Objects.requireNonNull(type);
        Objects.requireNonNull(records);
        return this.create(zoneId, (Recordset)DesignateRecordset.builder().name(name).type(type).records(records).build());
    }

    @Override
    public List<? extends Recordset> list(String zoneId) {
        Objects.requireNonNull(zoneId);
        return this.get(DesignateRecordset.Recordsets.class, "/zones", "/", zoneId, "/recordsets").execute().getList();
    }

    @Override
    public List<? extends Recordset> list() {
        return this.get(DesignateRecordset.Recordsets.class, this.uri("/recordsets", new Object[0])).execute().getList();
    }
}

