/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.openstack4j.api.Apis;
import org.openstack4j.api.compute.ServerService;
import org.openstack4j.api.compute.ext.InstanceActionsService;
import org.openstack4j.api.compute.ext.InterfaceService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.compute.Action;
import org.openstack4j.model.compute.RebootType;
import org.openstack4j.model.compute.Server;
import org.openstack4j.model.compute.ServerCreate;
import org.openstack4j.model.compute.ServerPassword;
import org.openstack4j.model.compute.ServerUpdateOptions;
import org.openstack4j.model.compute.VNCConsole;
import org.openstack4j.model.compute.VolumeAttachment;
import org.openstack4j.model.compute.actions.BackupOptions;
import org.openstack4j.model.compute.actions.EvacuateOptions;
import org.openstack4j.model.compute.actions.LiveMigrateOptions;
import org.openstack4j.model.compute.actions.RebuildOptions;
import org.openstack4j.model.compute.builder.ServerCreateBuilder;
import org.openstack4j.openstack.common.Metadata;
import org.openstack4j.openstack.compute.domain.AdminPass;
import org.openstack4j.openstack.compute.domain.ConsoleOutput;
import org.openstack4j.openstack.compute.domain.ConsoleOutputOptions;
import org.openstack4j.openstack.compute.domain.NovaPassword;
import org.openstack4j.openstack.compute.domain.NovaServer;
import org.openstack4j.openstack.compute.domain.NovaServerCreate;
import org.openstack4j.openstack.compute.domain.NovaServerUpdate;
import org.openstack4j.openstack.compute.domain.NovaVNCConsole;
import org.openstack4j.openstack.compute.domain.NovaVolumeAttachment;
import org.openstack4j.openstack.compute.domain.actions.BackupAction;
import org.openstack4j.openstack.compute.domain.actions.BasicActions;
import org.openstack4j.openstack.compute.domain.actions.CreateSnapshotAction;
import org.openstack4j.openstack.compute.domain.actions.EvacuateAction;
import org.openstack4j.openstack.compute.domain.actions.LiveMigrationAction;
import org.openstack4j.openstack.compute.domain.actions.RebuildAction;
import org.openstack4j.openstack.compute.domain.actions.ResetStateAction;
import org.openstack4j.openstack.compute.domain.actions.SecurityGroupActions;
import org.openstack4j.openstack.compute.domain.actions.ServerAction;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.compute.functions.WrapServerIfApplicableFunction;
import org.openstack4j.openstack.compute.internal.BaseComputeServices;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerServiceImpl
extends BaseComputeServices
implements ServerService {
    private static final Logger LOG = LoggerFactory.getLogger(ServerServiceImpl.class);

    @Override
    public List<? extends Server> list() {
        return this.list(true);
    }

    @Override
    public List<? extends Server> list(boolean detail) {
        return this.list(detail, Boolean.FALSE);
    }

    @Override
    public List<? extends Server> listAll(boolean detail) {
        return this.list(detail, Boolean.TRUE);
    }

    private List<? extends Server> list(boolean detail, boolean allTenants) {
        BaseOpenStackService.Invocation<NovaServer.Servers> req = this.get(NovaServer.Servers.class, this.uri("/servers" + (detail ? "/detail" : ""), new Object[0]));
        if (allTenants) {
            req.param("all_tenants", 1);
        }
        return req.execute().getList();
    }

    @Override
    public List<? extends Server> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NovaServer.Servers> serverInvocation = this.get(NovaServer.Servers.class, "/servers/detail");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                serverInvocation = serverInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return serverInvocation.execute().getList();
    }

    @Override
    public Server get(String serverId) {
        Objects.requireNonNull(serverId);
        return this.get(NovaServer.class, this.uri("/servers/%s", serverId)).execute();
    }

    @Override
    public Server boot(ServerCreate server) {
        Objects.requireNonNull(server);
        return this.post(NovaServer.class, this.uri("/servers", new Object[0])).entity(WrapServerIfApplicableFunction.INSTANCE.apply(server)).execute();
    }

    @Override
    public Server bootAndWaitActive(ServerCreate server, int maxWaitTime) {
        return this.waitForServerStatus(this.boot(server).getId(), Server.Status.ACTIVE, maxWaitTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public ActionResponse delete(String serverId) {
        Objects.requireNonNull(serverId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/servers/%s", serverId)).executeWithResponse());
    }

    @Override
    public ActionResponse action(String serverId, Action action) {
        Objects.requireNonNull(serverId);
        ServerAction instance = BasicActions.actionInstanceFor(action);
        if (instance == null) {
            return ActionResponse.actionFailed(String.format("Action %s was not found in the list of invokable actions", new Object[]{action}), 412);
        }
        return this.invokeAction(serverId, instance);
    }

    @Override
    public String createSnapshot(String serverId, String snapshotName) {
        return this.invokeCreateSnapshotAction(serverId, snapshotName, null);
    }

    @Override
    public String createSnapshot(String serverId, String snapshotName, Map<String, String> metadata) {
        return this.invokeCreateSnapshotAction(serverId, snapshotName, metadata);
    }

    private String invokeCreateSnapshotAction(String serverId, String snapshotName, Map<String, String> metadata) {
        String location;
        Objects.requireNonNull(serverId);
        Objects.requireNonNull(snapshotName);
        CreateSnapshotAction createSnapshotAction = metadata != null && !metadata.isEmpty() ? CreateSnapshotAction.create(snapshotName, metadata) : CreateSnapshotAction.create(snapshotName);
        HttpResponse response = this.invokeActionWithResponse(serverId, createSnapshotAction);
        String id = null;
        if (response.getStatus() == 202 && (location = response.header("location")) != null && location.contains("/")) {
            String[] s = location.split("/");
            id = s[s.length - 1];
        }
        response.getEntity(Void.class);
        return id;
    }

    @Override
    public ActionResponse reboot(String serverId, RebootType type) {
        Objects.requireNonNull(serverId);
        return this.invokeAction(serverId, new BasicActions.Reboot(type));
    }

    @Override
    public ActionResponse rebuild(String serverId, RebuildOptions options) {
        Objects.requireNonNull(serverId);
        return this.invokeAction(serverId, RebuildAction.create(options));
    }

    @Override
    public ActionResponse resize(String serverId, String flavorId) {
        Objects.requireNonNull(serverId);
        Objects.requireNonNull(flavorId);
        return this.invokeAction(serverId, new BasicActions.Resize(flavorId));
    }

    @Override
    public ActionResponse addSecurityGroup(String serverId, String secGroupName) {
        Objects.requireNonNull(serverId);
        Objects.requireNonNull(secGroupName);
        return this.invokeAction(serverId, SecurityGroupActions.add(secGroupName));
    }

    @Override
    public ActionResponse removeSecurityGroup(String serverId, String secGroupName) {
        Objects.requireNonNull(serverId);
        Objects.requireNonNull(secGroupName);
        return this.invokeAction(serverId, SecurityGroupActions.remove(secGroupName));
    }

    @Override
    public ActionResponse confirmResize(String serverId) {
        Objects.requireNonNull(serverId);
        return this.invokeAction(serverId, BasicActions.instanceFor(BasicActions.ConfirmResize.class));
    }

    @Override
    public ActionResponse revertResize(String serverId) {
        Objects.requireNonNull(serverId);
        return this.invokeAction(serverId, BasicActions.instanceFor(BasicActions.RevertResize.class));
    }

    @Override
    public String getConsoleOutput(String serverId, int numLines) {
        Objects.requireNonNull(serverId);
        ConsoleOutputOptions consoleOutputOptions = numLines <= 0 ? new ConsoleOutputOptions() : new ConsoleOutputOptions(numLines);
        ConsoleOutput c = this.post(ConsoleOutput.class, this.uri("/servers/%s/action", serverId)).entity(consoleOutputOptions).execute();
        return c != null ? c.getOutput() : null;
    }

    @Override
    public VNCConsole getVNCConsole(String serverId, VNCConsole.Type type) {
        Objects.requireNonNull(serverId);
        if (type == null) {
            type = VNCConsole.Type.NOVNC;
        }
        return this.post(NovaVNCConsole.class, this.uri("/servers/%s/action", serverId)).entity(NovaVNCConsole.getConsoleForType(type)).execute();
    }

    @Override
    public Map<String, ? extends Number> diagnostics(String serverId) {
        return this.get(HashMap.class, this.uri("/servers/%s/diagnostics", serverId)).execute();
    }

    @Override
    public ServerCreateBuilder serverBuilder() {
        return NovaServerCreate.builder();
    }

    @Override
    public VolumeAttachment attachVolume(String serverId, String volumeId, String device) {
        return this.post(NovaVolumeAttachment.class, this.uri("/servers/%s/os-volume_attachments", serverId)).entity(NovaVolumeAttachment.create(volumeId, device)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public ActionResponse detachVolume(String serverId, String attachmentId) {
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/servers/%s/os-volume_attachments/%s", serverId, attachmentId)).executeWithResponse());
    }

    @Override
    public ActionResponse migrateServer(String serverId) {
        Objects.requireNonNull(serverId);
        return this.invokeAction(serverId, BasicActions.instanceFor(BasicActions.Migrate.class));
    }

    @Override
    public ActionResponse liveMigrate(String serverId, LiveMigrateOptions options) {
        Objects.requireNonNull(serverId);
        if (options == null) {
            options = LiveMigrateOptions.create();
        }
        return this.invokeAction(serverId, LiveMigrationAction.create(options));
    }

    @Override
    public ActionResponse resetState(String serverId, Server.Status state) {
        Objects.requireNonNull(serverId);
        Objects.requireNonNull(state);
        return this.invokeAction(serverId, ResetStateAction.create(state));
    }

    @Override
    public ActionResponse backupServer(String serverId, BackupOptions options) {
        Objects.requireNonNull(serverId);
        Objects.requireNonNull(options);
        return this.invokeAction(serverId, BackupAction.create(options));
    }

    @Override
    public ActionResponse changeAdminPassword(String serverId, String adminPassword) {
        Objects.requireNonNull(serverId);
        Objects.requireNonNull(adminPassword);
        return this.invokeAction(serverId, new BasicActions.ChangePassword(adminPassword));
    }

    @Override
    public Server waitForServerStatus(String serverId, Server.Status status, int maxWait, TimeUnit maxWaitUnit) {
        Objects.requireNonNull(serverId);
        Server server = null;
        long maxTime = maxWaitUnit.toMillis(maxWait);
        for (long duration = 0L; duration < maxTime && (server = this.get(serverId)) != null && server.getStatus() != status && server.getStatus() != Server.Status.ERROR; duration += (long)this.sleep(1000)) {
        }
        return server;
    }

    @Override
    public Map<String, String> getMetadata(String serverId) {
        Objects.requireNonNull(serverId);
        return this.get(Metadata.class, this.uri("/servers/%s/metadata", serverId)).execute();
    }

    @Override
    public Map<String, String> updateMetadata(String serverId, Map<String, String> metadata) {
        Objects.requireNonNull(serverId);
        Objects.requireNonNull(metadata);
        return this.put(Metadata.class, this.uri("/servers/%s/metadata", serverId)).entity(Metadata.toMetadata(metadata)).execute();
    }

    @Override
    public ActionResponse deleteMetadataItem(String serverId, String key) {
        Objects.requireNonNull(serverId);
        Objects.requireNonNull(key);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/servers/%s/metadata/%s", serverId, key)).executeWithResponse());
    }

    private int sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return ms;
    }

    @Override
    public Server update(String serverId, ServerUpdateOptions options) {
        Objects.requireNonNull(serverId);
        Objects.requireNonNull(options);
        return this.put(NovaServer.class, this.uri("/servers/%s", serverId)).entity(NovaServerUpdate.fromOptions(options)).execute();
    }

    @Override
    public InterfaceService interfaces() {
        return Apis.get(InterfaceService.class);
    }

    @Override
    public InstanceActionsService instanceActions() {
        return Apis.get(InstanceActionsService.class);
    }

    @Override
    public ServerPassword getPassword(String serverId) {
        Objects.requireNonNull(serverId);
        return this.get(NovaPassword.class, this.uri("/servers/%s/os-server-password", serverId)).execute();
    }

    @Override
    public ServerPassword evacuate(String serverId, EvacuateOptions options) {
        Objects.requireNonNull(serverId);
        return this.post(AdminPass.class, this.uri("/servers/%s/action", serverId)).entity(EvacuateAction.create(options)).execute();
    }
}

