/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.internal;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openstack4j.api.compute.KeypairService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.compute.Keypair;
import org.openstack4j.openstack.compute.domain.NovaKeypair;
import org.openstack4j.openstack.compute.internal.BaseComputeServices;

public class KeypairServiceImpl
extends BaseComputeServices
implements KeypairService {
    @Override
    public List<? extends Keypair> list() {
        return this.get(NovaKeypair.Keypairs.class, this.uri("/os-keypairs", new Object[0])).execute().getList();
    }

    @Override
    public Keypair get(String name) {
        Objects.requireNonNull(name);
        return this.get(NovaKeypair.class, this.uri("/os-keypairs/%s", name)).execute();
    }

    @Override
    public ActionResponse delete(String name) {
        Objects.requireNonNull(name);
        return this.deleteWithResponse(this.uri("/os-keypairs/%s", name)).execute();
    }

    @Override
    public Keypair create(String name, @Nullable String publicKey) {
        Objects.requireNonNull(name);
        return this.post(NovaKeypair.class, this.uri("/os-keypairs", new Object[0])).entity(NovaKeypair.create(name, publicKey)).execute();
    }
}

