/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.common.functions;

import java.util.function.Function;

public class RemoveVersionFromURL
implements Function<String, String> {
    public static final String VERSION_REGEX = "/v[0-9]+(\\.[0-9])*";
    public static final RemoveVersionFromURL INSTANCE = new RemoveVersionFromURL();

    @Override
    public String apply(String url) {
        String result = url.replaceFirst(VERSION_REGEX, "");
        if (result.endsWith("/")) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }

    public String removeAndApply(String url, String version) {
        if (url == null) {
            return url;
        }
        return this.apply(url).concat(version);
    }
}

