/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.model.common.DLPayload;

public class DLPayloadEntity
implements DLPayload {
    private final HttpResponse response;

    private DLPayloadEntity(HttpResponse response) {
        this.response = response;
    }

    public static DLPayloadEntity create(HttpResponse response) {
        return new DLPayloadEntity(response);
    }

    @Override
    public HttpResponse getHttpResponse() {
        return this.response;
    }

    @Override
    public InputStream getInputStream() {
        return this.response.getInputStream();
    }

    @Override
    public void writeToFile(File file) throws IOException {
        Objects.requireNonNull(file);
        try (InputStream inputStream = this.response.getInputStream();
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int length;
            byte[] buf = new byte[8192];
            while ((length = inputStream.read(buf)) > 0) {
                fileOutputStream.write(buf, 0, length);
            }
        }
    }
}

