/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.barbican.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.barbican.SecretService;
import org.openstack4j.model.barbican.Secret;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.openstack.barbican.domain.BarbicanSecret;
import org.openstack4j.openstack.barbican.internal.BaseBarbicanServices;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class SecretServiceImpl
extends BaseBarbicanServices
implements SecretService {
    private static final String RESOURCE_PATH = "/secrets";
    private static final String SPECIFIC_RESOURCE_PATH = "/secrets/%s";

    @Override
    public List<? extends Secret> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<BarbicanSecret.Secrets> req = this.get(BarbicanSecret.Secrets.class, this.uri(RESOURCE_PATH, new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public List<? extends Secret> list(String name) {
        return this.list(Collections.singletonMap("name", name));
    }

    @Override
    public Secret get(String secretId) {
        Objects.requireNonNull(secretId);
        return this.get(BarbicanSecret.class, this.uri(SPECIFIC_RESOURCE_PATH, secretId)).execute();
    }

    @Override
    public ActionResponse delete(String secretId) {
        Objects.requireNonNull(secretId);
        return this.deleteWithResponse(this.uri(SPECIFIC_RESOURCE_PATH, secretId)).execute();
    }

    @Override
    public Secret create(Secret secret) {
        Objects.requireNonNull(secret);
        return this.post(BarbicanSecret.class, this.uri(RESOURCE_PATH, new Object[0])).entity(secret).execute();
    }
}

