/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.barbican.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.barbican.ContainerService;
import org.openstack4j.model.barbican.Container;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.openstack.barbican.domain.BarbicanContainer;
import org.openstack4j.openstack.barbican.internal.BaseBarbicanServices;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class ContainerServiceImpl
extends BaseBarbicanServices
implements ContainerService {
    private static final String RESOURCE_PATH = "/containers";
    private static final String SPECIFIC_RESOURCE_PATH = "/containers/%s";

    @Override
    public List<? extends Container> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<BarbicanContainer.Containers> req = this.get(BarbicanContainer.Containers.class, this.uri(RESOURCE_PATH, new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public List<? extends Container> list(String name) {
        return this.list(Collections.singletonMap("name", name));
    }

    @Override
    public Container get(String containerId) {
        Objects.requireNonNull(containerId);
        return this.get(BarbicanContainer.class, this.uri(SPECIFIC_RESOURCE_PATH, containerId)).execute();
    }

    @Override
    public ActionResponse delete(String containerId) {
        Objects.requireNonNull(containerId);
        return this.deleteWithResponse(this.uri(SPECIFIC_RESOURCE_PATH, containerId)).execute();
    }

    @Override
    public Container create(Container container) {
        Objects.requireNonNull(container);
        return this.post(BarbicanContainer.class, this.uri(RESOURCE_PATH, new Object[0])).entity(container).execute();
    }
}

