/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.barbican.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.barbican.Secret;
import org.openstack4j.model.barbican.builder.SecretCreateBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

public class BarbicanSecret
implements Secret {
    private String name;
    @JsonProperty(value="algorithm")
    private String algorithm;
    @JsonProperty(value="bit_length")
    private Integer bitLength;
    @JsonProperty(value="content_types")
    private Map<String, String> contentTypes;
    @JsonProperty(value="created")
    private Date createTime;
    @JsonProperty(value="updated")
    private Date updateTime;
    @JsonProperty(value="creator_id")
    private String creatorId;
    @JsonProperty(value="expiration")
    private Date expiration;
    @JsonProperty(value="mode")
    private String mode;
    @JsonProperty(value="secret_ref")
    private String secretReference;
    @JsonProperty(value="secret_type")
    private String secretType;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="payload")
    private String payload;
    @JsonProperty(value="payload_content_type")
    private String payloadContentType;
    @JsonProperty(value="payload_content_encoding")
    private String payloadContentEncoding;

    public static SecretCreateBuilder builder() {
        return new SecretCreateConcreteBuilder();
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public Integer getBitLength() {
        return this.bitLength;
    }

    @Override
    public Map<String, String> getContentTypes() {
        return this.contentTypes;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public Date getExpiration() {
        return this.expiration;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSecretReference() {
        return this.secretReference;
    }

    @Override
    public String getSecretType() {
        return this.secretType;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public String getPayloadContentType() {
        return this.payloadContentType;
    }

    @Override
    public String getPayloadContentEncoding() {
        return this.payloadContentEncoding;
    }

    public String toString() {
        return new ToStringHelper(this).add("algorithm", this.algorithm).add("bit_length", this.bitLength).add("content_types", this.contentTypes).add("created", this.createTime).add("creator_id", this.creatorId).add("expiration", this.expiration).add("mode", this.mode).add("name", this.name).add("secret_ref", this.secretReference).add("secret_type", this.secretType).add("status", this.status).add("updated", this.updateTime).toString();
    }

    @Override
    public SecretCreateBuilder toBuilder() {
        return new SecretCreateConcreteBuilder();
    }

    public static class SecretCreateConcreteBuilder
    implements SecretCreateBuilder {
        private BarbicanSecret internalSecret;

        public SecretCreateConcreteBuilder() {
            this(new BarbicanSecret());
        }

        public SecretCreateConcreteBuilder(BarbicanSecret secret) {
            this.internalSecret = secret;
        }

        @Override
        public SecretCreateBuilder name(String name) {
            this.internalSecret.name = name;
            return this;
        }

        @Override
        public SecretCreateBuilder expiration(Date expiration) {
            this.internalSecret.expiration = expiration;
            return this;
        }

        @Override
        public SecretCreateBuilder algorithm(String algorithm) {
            this.internalSecret.algorithm = algorithm;
            return this;
        }

        @Override
        public SecretCreateBuilder bitLength(Integer bitLength) {
            this.internalSecret.bitLength = bitLength;
            return this;
        }

        @Override
        public SecretCreateBuilder mode(String mode) {
            this.internalSecret.mode = mode;
            return this;
        }

        @Override
        public SecretCreateBuilder payload(String payload) {
            this.internalSecret.payload = payload;
            return this;
        }

        @Override
        public SecretCreateBuilder payloadContentType(String payloadContentType) {
            this.internalSecret.payloadContentType = payloadContentType;
            return this;
        }

        @Override
        public SecretCreateBuilder payloadContentEncoding(String payloadContentEncoding) {
            this.internalSecret.payloadContentEncoding = payloadContentEncoding;
            return this;
        }

        @Override
        public SecretCreateBuilder secretType(String secretType) {
            this.internalSecret.secretType = secretType;
            return this;
        }

        @Override
        public Secret build() {
            return this.internalSecret;
        }

        @Override
        public SecretCreateBuilder from(Secret in) {
            this.internalSecret = (BarbicanSecret)in;
            return this;
        }
    }

    public static class Secrets
    extends ListResult<BarbicanSecret> {
        @JsonProperty(value="total")
        private int count;
        @JsonProperty(value="secrets")
        private List<BarbicanSecret> list;

        @Override
        protected List<BarbicanSecret> value() {
            return this.list;
        }

        public int getCount() {
            return this.count;
        }
    }
}

